/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.commons.lang3.StringEscapeUtils;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.StackTraceInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.util.EntityVisitorUtils;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.html.StatisticsClassInfoVisitor;
import com.atlassian.clover.reporters.util.ReportColors;
import com.atlassian.clover.spi.reporters.html.source.HtmlRenderingSupport;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.Formatting;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Maps;

public class HtmlRenderingSupportImpl
implements HtmlRenderingSupport {
    private final Format format;
    private final boolean filter;
    private static final String FILE_REGEXP = "[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)";
    private static final Pattern TRACE_LINE_PATTERN = Pattern.compile("((([\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.)*[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*)\\.(?:&lt;)?[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*(?:&gt;)?)\\(([\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)|Unknown Source)\\)");
    private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)");

    public HtmlRenderingSupportImpl() {
        this(Format.DEFAULT_HTML, true);
    }

    public HtmlRenderingSupportImpl(Format format, boolean filter) {
        this.format = format;
        this.filter = filter;
    }

    public Map<String, Number> collectColumnValues(List<Column> columns, HasMetrics info) throws CloverException {
        HashMap<String, Number> columnValues = Maps.newHashMap();
        for (Column col : columns) {
            BlockMetrics metrics = this.metricsFor(info);
            col.init(metrics);
            columnValues.put(col.getName(), col.getNumber());
            col.reset();
        }
        return columnValues;
    }

    public BlockMetrics metricsFor(HasMetrics info) {
        return !this.filter ? info.getRawMetrics() : info.getMetrics();
    }

    public String formatShortDate(long ts) {
        return Formatting.formatShortDate(new Date(ts));
    }

    public String getPercentStr(float aPc) {
        return Formatting.getPercentStr(aPc);
    }

    public String getRemainderPercentStr(float aPc) {
        float remainder = this.getRemainder(aPc);
        return this.getPercentStr(remainder);
    }

    private float getRemainder(float aPc) {
        return aPc < 0.0f ? -1.0f : 1.0f - aPc;
    }

    public String getPkgURLPath(String aPkg) {
        return String.valueOf(aPkg.replace('.', '/')) + "/";
    }

    public String getPkgURLPath(String aPkg, String aFile) {
        return String.valueOf(aPkg.replace('.', '/')) + "/" + aFile;
    }

    public String getFileIdentifier(FullFileInfo aFile) {
        return aFile.getPackagePath().replace('/', '_').replace('.', '_');
    }

    @Override
    public String getRootRelPath(String aPkg) {
        int l = aPkg.length();
        if (l == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(l);
        buf.append("../");
        int i = 0;
        while (i < l) {
            if (aPkg.charAt(i) == '.') {
                buf.append("../");
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String getPackageRelPath(String pkgA, String pkgB) {
        if (pkgA == null || pkgA.compareTo("") == 0) {
            return this.getRootRelPath(pkgB);
        }
        if (pkgB == null || pkgB.compareTo("") == 0) {
            return this.getPkgURLPath(pkgA);
        }
        StringTokenizer pkgATokens = new StringTokenizer(pkgA, ".");
        StringTokenizer pkgBTokens = new StringTokenizer(pkgB, ".");
        String tokenA = null;
        String tokenB = null;
        while (pkgATokens.hasMoreTokens() && pkgBTokens.hasMoreTokens()) {
            tokenA = pkgATokens.nextToken();
            if (tokenA.compareTo(tokenB = pkgBTokens.nextToken()) != 0) break;
        }
        StringBuilder buf = new StringBuilder();
        if (tokenB != null) {
            buf.append("../");
        }
        while (pkgBTokens.hasMoreTokens()) {
            pkgBTokens.nextToken();
            buf.append("../");
        }
        if (tokenA != null) {
            buf.append(tokenA).append("/");
        }
        while (pkgATokens.hasMoreTokens()) {
            buf.append(pkgATokens.nextToken()).append("/");
        }
        return buf.toString();
    }

    public String getWrappablePath(String aStr) {
        int l = aStr.length();
        StringBuilder buf = new StringBuilder(l);
        int i = 0;
        while (i < l) {
            if (aStr.charAt(i) == File.separatorChar) {
                buf.append(File.separatorChar).append(" ");
            } else {
                buf.append(aStr.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public StringBuffer getTestFileName(TestCaseInfo testInfo) {
        String name = testInfo.getTestName();
        String className = testInfo.getRuntimeType().getName();
        StringBuffer link = new StringBuffer();
        link.append(className.replaceAll("\\W", "_")).append("_").append(name.replaceAll("\\W", "_")).append("_").append(Integer.toString(testInfo.getId(), 36)).append(".html");
        return link;
    }

    public StringBuffer getTestLink(boolean topLevel, TestCaseInfo testInfo) {
        StringBuffer link = new StringBuffer();
        if (testInfo == null || !testInfo.isResolved()) {
            Logger.getInstance().debug("No test information found" + (testInfo == null ? "." : " for " + testInfo.getRuntimeTypeName() + "." + testInfo.getSourceMethodName()));
            return link;
        }
        if (topLevel) {
            String pkgURLPath = this.getPkgURLPath(testInfo.getRuntimeType().getPackage().getName());
            link.append(pkgURLPath);
        }
        link.append(this.getTestFileName(testInfo));
        return link;
    }

    public StringBuffer getSrcFileLink(boolean toplevel, BaseClassInfo cls, long idParam) {
        String cname = cls.getName();
        FileInfo fileInfo = cls.getContainingFile();
        String file = fileInfo != null ? fileInfo.getName() : "";
        String pkgName = cls.getPackage().getName();
        StringBuffer srcFileLink = this.getSrcFileLink(toplevel, true, cname, file, pkgName);
        return this.insertQueryParams(srcFileLink, idParam);
    }

    private StringBuffer insertQueryParams(StringBuffer srcFileLink, long idParam) {
        StringBuffer retVal = new StringBuffer();
        int hashIndex = srcFileLink.lastIndexOf("#");
        String paramString = "?id=" + idParam;
        if (hashIndex >= 0) {
            retVal.append(srcFileLink.substring(0, hashIndex));
            retVal.append(paramString);
            retVal.append(srcFileLink.substring(hashIndex, srcFileLink.length()));
        } else {
            retVal.append(srcFileLink).append(paramString);
        }
        return retVal;
    }

    public StringBuffer getFileLink(boolean toplevel, BaseFileInfo fileInfo) {
        String file = fileInfo.getName();
        String pkgName = fileInfo.getContainingPackage().getName();
        return this.getSrcFileLink(toplevel, false, file, file, pkgName);
    }

    public StringBuffer getSrcFileLink(boolean toplevel, boolean withAnchor, BaseClassInfo cls, BasePackageInfo pkgInContext) {
        String cname = cls.getName();
        FileInfo fileInfo = cls.getContainingFile();
        String file = fileInfo != null ? fileInfo.getName() : "";
        String pkgName = cls.getPackage().getName();
        String pkgNameInContext = pkgInContext.getName();
        StringBuffer link = new StringBuffer();
        link.append(this.getPackageRelPath(pkgName, pkgNameInContext));
        this.appendBaseFileName(link, file);
        if (withAnchor) {
            link.append("#").append(cname);
        }
        return link;
    }

    @Override
    public StringBuffer getSrcFileLink(boolean toplevel, boolean withAnchor, ClassInfo cls) {
        String cname = cls.getName();
        FileInfo fileInfo = cls.getContainingFile();
        String file = fileInfo != null ? fileInfo.getName() : "";
        String pkgName = cls.getPackage().getName();
        return this.getSrcFileLink(toplevel, withAnchor, cname, file, pkgName);
    }

    public String getMethodLink(boolean toplevel, FullMethodInfo mthd) {
        if (mthd == null) {
            return "";
        }
        return this.getSrcLineLink(toplevel, mthd.getContainingFile(), mthd.getStartLine());
    }

    public String getSrcLineLink(boolean toplevel, FileInfo file, int line) {
        StringBuffer link = new StringBuffer();
        this.appendBaseDirectoryName(link, toplevel, file.getContainingPackage().getName());
        this.appendBaseFileName(link, file.getName());
        if (line != -1) {
            link.append("?line=").append(line).append("#src-").append(line);
        }
        return link.toString();
    }

    public StringBuffer getSrcFileLink(boolean isTopLevel, boolean withAnchor, String className, String containingFileName, String packageName) {
        StringBuffer link = new StringBuffer();
        this.appendBaseDirectoryName(link, isTopLevel, packageName);
        this.appendBaseFileName(link, containingFileName);
        if (withAnchor) {
            link.append("#").append(className);
        }
        return link;
    }

    public String getMethodIndentiation(MethodInfo methodInfo) {
        EntityVisitorUtils utils = new EntityVisitorUtils();
        StringBuilder indent = new StringBuilder();
        MethodInfo current = methodInfo;
        while ((current = utils.GET_PARENT.asMethod(current)) != null) {
            indent.append("&#160;&#160;&#160;&#160;");
        }
        return indent.toString();
    }

    private String appendBaseDirectoryName(StringBuffer link, boolean isTopLevel, String packageName) {
        String pkgUrl = isTopLevel ? this.getPkgURLPath(packageName) : "";
        link.append(pkgUrl);
        return pkgUrl;
    }

    private void appendBaseFileName(StringBuffer link, String containingFileName) {
        String basename = containingFileName.substring(0, containingFileName.lastIndexOf("."));
        link.append(basename).append(".html");
    }

    public String getBaseFileName(BaseClassInfo classInfo) {
        String normalizedPath;
        StringBuffer buf = new StringBuffer();
        this.appendBaseDirectoryName(buf, true, classInfo.getPackage().getName());
        String fileName = normalizedPath = FileUtils.getNormalizedPath(classInfo.getContainingFile().getName());
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        this.appendBaseFileName(buf, fileName);
        return buf.toString();
    }

    public static int getWidth(int w, float aPc) {
        return (int)((float)w * Math.abs(aPc));
    }

    public static int getRemainder(int w, float aPc) {
        return w - HtmlRenderingSupportImpl.getWidth(w, aPc);
    }

    public static String getPcWidth(float pc) {
        return Formatting.getPcWidth(100.0f * pc);
    }

    public static String getPcWidth(Float pc) {
        return HtmlRenderingSupportImpl.getPcWidth(pc.floatValue());
    }

    public String getRemainderPcWidth(float pc) {
        float remainder = this.getRemainder(pc);
        if (remainder < 0.0f) {
            return "0";
        }
        return Formatting.getPcWidth(100.0f * remainder);
    }

    public String format1d(float pc) {
        return this.formatMultiply1d(pc, 100.0f);
    }

    public String formatMultiply1d(float pc, float multiplier) {
        return Formatting.format1d(pc * multiplier);
    }

    public String formatMultiply1dReverse(float pc, float multiplier, float max) {
        return this.formatMultiply1d(max - pc, multiplier);
    }

    public String truncateEnd(String str) {
        return this.htmlEscapeStr(Formatting.restrictLength(str, this.format.getMaxNameLength(), false));
    }

    public String truncateEnd(String str, int length) {
        return this.htmlEscapeStr(Formatting.restrictLength(str, length, false));
    }

    public String truncateStart(String str) {
        return this.htmlEscapeStr(Formatting.restrictLength(str, this.format.getMaxNameLength(), true));
    }

    public String formatInt(int aVal) {
        return Formatting.formatInt(aVal);
    }

    public String format2d(double aVal) {
        return Formatting.format2d(aVal);
    }

    public String format3d(double aVal) {
        return Formatting.format3d(aVal);
    }

    public String capitalize(String s) {
        if (s != null) {
            if (s.length() > 1) {
                return String.valueOf(s.substring(0, 1).toUpperCase(Locale.ENGLISH)) + s.substring(1);
            }
            return s.toUpperCase(Locale.ENGLISH);
        }
        return s;
    }

    public String joinWithDots(String s1, String s2) {
        return String.valueOf(s1) + (s1.isEmpty() || s2.isEmpty() ? "" : ".") + s2;
    }

    public void listAddKeyAsLast(@NotNull ArrayList<String> list, @NotNull String key) {
        String prefix = list.size() > 0 ? list.get(list.size() - 1) : "";
        list.add(this.joinWithDots(prefix, key));
    }

    @Nullable
    public String listGetLast(@NotNull ArrayList<String> list) {
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    public void listRemoveLast(@NotNull ArrayList list) {
        if (list.size() > 0) {
            list.remove(list.size() - 1);
        }
    }

    public int contains(Set set, int key) {
        return set.contains(key) ? 1 : 0;
    }

    public int length(Object[] array) {
        return array != null ? array.length : -1;
    }

    public String htmlEscapeStr(String aString) {
        return this.htmlEscapeStr(aString, "&#09;", "&#160;");
    }

    @Override
    public String htmlEscapeStr(String aString, String tabString, String spaceString) {
        if (aString == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(aString.length() * 3);
        int i = 0;
        int j = aString.length();
        while (i < j) {
            char c = aString.charAt(i);
            switch (c) {
                case ' ': {
                    buf.append(spaceString);
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\t': {
                    buf.append(tabString);
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String javaScriptEscapeStr(String input) {
        return StringEscapeUtils.escapeJson(input);
    }

    public String linkifyStackTrace(String rootRelPath, FullProjectInfo proj, String trace) {
        StringBuffer buff = new StringBuffer();
        Matcher matcher = TRACE_LINE_PATTERN.matcher(this.htmlEscapeStr(trace, " ", " "));
        while (matcher.find()) {
            String srcLineLink;
            String fqcn = matcher.group(2).replace('$', '.');
            FullClassInfo clazz = (FullClassInfo)proj.findClass(fqcn);
            Logger.getInstance().debug(String.valueOf(fqcn) + " ... " + (clazz != null ? "found" : "CLASS NOT FOUND"));
            if (clazz == null) continue;
            String pkgName = clazz.getPackage().getName();
            String lineStr = matcher.group(4);
            if (LINE_NUMBER_PATTERN.matcher(lineStr).matches()) {
                int line = Integer.parseInt(matcher.group(5));
                srcLineLink = this.getSrcLineLink(false, clazz.getContainingFile(), line);
            } else {
                StringBuffer srcLinkBuf = this.getSrcFileLink(false, true, clazz);
                srcLineLink = srcLinkBuf != null ? srcLinkBuf.toString() : "";
            }
            String escapedLine = matcher.group(0).replaceAll("\\$", "\\\\\\$");
            Logger.getInstance().debug("Linkifying: '" + escapedLine + "'");
            matcher.appendReplacement(buff, "<a href=\"" + rootRelPath + this.getPkgURLPath(pkgName) + srcLineLink + "\">" + escapedLine + "</a>");
        }
        StringBuffer tail = new StringBuffer();
        matcher.appendTail(tail);
        Logger.getInstance().debug("Appending non-linkified tail: '" + tail + "'");
        return buff.append(tail).toString();
    }

    public String linkifyStackTrace(String rootRelPath, StackTraceInfo trace) {
        StringBuilder buff = new StringBuilder();
        for (Object entryObj : trace.getEntries()) {
            StackTraceInfo.TraceEntry entry = (StackTraceInfo.TraceEntry)entryObj;
            buff.append("<div>");
            if (entry.isResolved()) {
                buff.append(entry.getLinePrefix());
                buff.append("<a href=\"").append(rootRelPath).append(this.getSrcLineLink(true, entry.getContainingFile(), entry.getLineNum()));
                buff.append("\">").append(this.htmlEscapeStr(entry.getLinkableLineSegment(), " ", " ")).append("</a>");
            } else {
                buff.append(this.htmlEscapeStr(entry.getLine(), " ", " "));
            }
            buff.append("</div>");
        }
        return buff.toString();
    }

    public String getTestClassLink(boolean topLevel, ClassInfo classInfo) {
        StringBuilder outname = new StringBuilder();
        if (topLevel) {
            String pkgURLPath = this.getPkgURLPath(classInfo.getPackage().getName());
            outname.append(pkgURLPath);
        }
        outname.append("test-").append(classInfo.getName().replaceAll("\\W", "_")).append(".html");
        return outname.toString();
    }

    public int constrain(float input, int min, int max) {
        int diff = max - min;
        return min + (int)(input * (float)diff);
    }

    public int getFontSize(StatisticsClassInfoVisitor stats, BaseClassInfo classInfo, int min, int max) {
        int result = stats.getCalculator().getScaledValue(classInfo);
        float pcResult = this.getFraction(result, stats.getMax());
        return this.constrain(pcResult, min, max);
    }

    public String getColor(StatisticsClassInfoVisitor stats, BaseClassInfo classInfo) {
        int result = stats.getCalculator().getScaledValue(classInfo);
        return ReportColors.ADG_COLORS.getStringColor(this.getFraction(result, stats.getMax()));
    }

    public float getFraction(float num, long dem) {
        if (dem != 0L) {
            return num / (float)dem;
        }
        return -1.0f;
    }

    public Set<TestCaseInfo> tcisInHitRange(Map<TestCaseInfo, BitSet> tcisAndHits, CoverageDataRange range) {
        return CoverageData.tcisInHitRange(tcisAndHits, range);
    }

    public static String pluralize(int value, String word) {
        return Formatting.pluralizedWord(value, word);
    }

    public static String blankNonAlpha(String input) {
        return input.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public static String isAre(int value) {
        return value == 1 ? "is" : "are";
    }
}

