/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.MethodSignatureInfo;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.TokenListUtil;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.entities.AnnotationImpl;
import com.atlassian.clover.registry.entities.ModifierExt;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.entities.Parameter;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class MethodSignature
implements TaggedPersistent,
MethodSignatureInfo {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Parameter[] EMPTY_PARAMS = new Parameter[0];
    private Map<String, List<String>> tags = Maps.newHashMap();
    private Modifiers modifiers = new Modifiers();
    private String name = "";
    private String typeParams = "";
    private String returnType = "";
    private Parameter[] parameters = new Parameter[0];
    private String[] throwsTypes = new String[0];
    public transient String normSeqPrefix;
    public transient String normSeqSuffix;

    public MethodSignature(String name) {
        this.name = name;
    }

    public MethodSignature(String name, int modifiers, AnnotationImpl[] annotations) {
        this.name = name;
        this.modifiers = Modifiers.createFrom(modifiers, annotations);
    }

    public MethodSignature(String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes, Modifiers modifiers) {
        this(null, null, null, name, typeParams, returnType, parameters, throwsTypes);
        this.modifiers = modifiers;
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes) {
        this(firstToken, nameToken, lastToken, new HashMap<String, List<String>>(), new Modifiers(), name, typeParams, returnType, parameters, throwsTypes);
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, Map<String, List<String>> tags, Modifiers modifiers, String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes) {
        if (firstToken != null || lastToken != null) {
            int mods = modifiers.getMask();
            mods &= 0xFFFFFFFA;
            this.normSeqPrefix = String.valueOf(ModifierExt.toString(mods |= 2)) + (typeParams != null ? " " + typeParams : "") + (returnType != null ? " " + returnType : "") + " ";
            this.normSeqSuffix = TokenListUtil.getNormalisedSequence(nameToken.getNext(), lastToken);
        }
        this.tags = this.flyweightIfEmptyFor(tags);
        this.modifiers = modifiers;
        this.name = name;
        this.typeParams = typeParams;
        this.returnType = returnType;
        this.parameters = this.flyweightIfEmptyFor(parameters);
        this.throwsTypes = this.flyweightIfEmptyFor(throwsTypes);
    }

    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    public int getModifiersMask() {
        return this.modifiers.getMask();
    }

    public void setModifiers(int modifiers) {
        this.modifiers.setMask(modifiers);
    }

    @Override
    public Modifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    @NotNull
    public Map<String, Collection<Annotation>> getAnnotations() {
        return this.modifiers.getAnnotations();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getTypeParams() {
        return this.typeParams;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasParams() {
        return this.parameters != null && this.parameters.length > 0;
    }

    @Override
    public int getParamCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    public String listParamTypes() {
        StringBuilder types = new StringBuilder();
        String sep = "";
        int i = 0;
        while (this.parameters != null && i < this.parameters.length) {
            types.append(sep);
            types.append(this.parameters[i].getType());
            sep = ",";
            ++i;
        }
        return types.toString();
    }

    public String listParamIdents() {
        StringBuilder idents = new StringBuilder();
        String sep = "";
        int i = 0;
        while (this.parameters != null && i < this.parameters.length) {
            idents.append(sep);
            idents.append(this.parameters[i].getName());
            sep = ",";
            ++i;
        }
        return idents.toString();
    }

    public boolean hasThrowsTypes() {
        return this.throwsTypes != null && this.throwsTypes.length > 0;
    }

    @Override
    public String[] getThrowsTypes() {
        return this.throwsTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRenamedNormalisedSignature(String newName) {
        if (this.normSeqPrefix == null) {
            throw new IllegalStateException("This signature is not renameable.");
        }
        StringBuilder renamed = new StringBuilder();
        renamed.append(this.normSeqPrefix);
        renamed.append(" ");
        renamed.append(newName);
        renamed.append(this.normSeqSuffix);
        return renamed.toString();
    }

    private <K, V> Map<K, V> flyweightIfEmptyFor(Map<K, V> map) {
        return map == null || map.isEmpty() ? Collections.emptyMap() : map;
    }

    private String[] flyweightIfEmptyFor(String[] strings) {
        return strings != null && strings.length == 0 ? EMPTY_STRINGS : strings;
    }

    private Parameter[] flyweightIfEmptyFor(Parameter[] params) {
        return params != null && params.length == 0 ? EMPTY_PARAMS : params;
    }

    public static void writeNull(DataOutput out) throws IOException {
        out.writeBoolean(false);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.typeParams);
        out.writeUTF(this.returnType);
        out.write(Modifiers.class, this.modifiers);
        Set<Map.Entry<String, List<String>>> entries = this.tags.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<String, List<String>> entry : entries) {
            out.writeUTF(entry.getKey());
            List<String> values = entry.getValue();
            out.writeInt(values.size());
            for (String value : values) {
                out.writeUTF(value);
            }
        }
        int numParameters = this.parameters == null ? 0 : this.parameters.length;
        out.writeInt(numParameters);
        int i = 0;
        while (i < numParameters) {
            out.write(Parameter.class, this.parameters[i]);
            ++i;
        }
        int numThrowsTypes = this.throwsTypes == null ? 0 : this.throwsTypes.length;
        out.writeInt(numThrowsTypes);
        int i2 = 0;
        while (i2 < numThrowsTypes) {
            out.writeUTF(this.throwsTypes[i2]);
            ++i2;
        }
    }

    public static MethodSignature read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        String typeParam = in.readUTF();
        String returnType = in.readUTF();
        Modifiers modifiers = in.read(Modifiers.class);
        int numTagEntries = in.readInt();
        HashMap<String, List<String>> tags = Maps.newHashMap();
        int i = 0;
        while (i < numTagEntries) {
            String key = in.readUTF();
            int numValues = in.readInt();
            LinkedList values = Lists.newLinkedList();
            int j = 0;
            while (j < numValues) {
                values.add(in.readUTF());
                ++j;
            }
            tags.put(key, values);
            ++i;
        }
        int numParameters = in.readInt();
        Parameter[] parameters = numParameters == 0 ? EMPTY_PARAMS : new Parameter[numParameters];
        int i2 = 0;
        while (i2 < numParameters) {
            parameters[i2] = in.read(Parameter.class);
            ++i2;
        }
        int numThrowsTypes = in.readInt();
        String[] throwsTypes = numThrowsTypes == 0 ? EMPTY_STRINGS : new String[numThrowsTypes];
        int i3 = 0;
        while (i3 < numThrowsTypes) {
            throwsTypes[i3] = in.readUTF();
            ++i3;
        }
        return new MethodSignature(null, null, null, tags, modifiers, name, typeParam, returnType, parameters, throwsTypes);
    }

    @Override
    public String getNormalizedSignature() {
        String modifiers = ModifierExt.toString(this.getModifiersMask());
        StringBuilder builder = new StringBuilder();
        builder.append(modifiers).append(" ");
        if (this.typeParams != null && !"".equals(this.typeParams)) {
            builder.append(this.typeParams).append(" ");
        }
        if (this.getReturnType() != null && this.getReturnType().length() > 0) {
            builder.append(this.getReturnType()).append(" ");
        }
        builder.append(this.getName());
        this.appendParameters(builder);
        this.appendThrowsClause(builder);
        return builder.toString();
    }

    private void appendThrowsClause(StringBuilder builder) {
        if (this.hasThrowsTypes()) {
            builder.append(" throws ");
            String[] stringArray = this.getThrowsTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                builder.append(e).append(", ");
                ++n2;
            }
            MethodSignature.removeLastTwo(builder);
        }
    }

    private void appendParameters(StringBuilder builder) {
        builder.append("(");
        if (this.hasParams()) {
            Parameter[] parameterArray = this.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                builder.append(param.getType()).append(" ").append(param.getName()).append(", ");
                ++n2;
            }
            if (this.getParameters().length > 0) {
                MethodSignature.removeLastTwo(builder);
            }
        }
        builder.append(")");
    }

    private static void removeLastTwo(StringBuilder builder) {
        builder.delete(builder.length() - 2, builder.length());
    }

    public String toString() {
        return "MethodSignature{throwsTypes=" + (this.throwsTypes == null ? null : Arrays.toString(this.throwsTypes)) + ", tags=" + this.tags + ", modifiers=" + this.modifiers + ", name='" + this.name + '\'' + ", typeParams='" + this.typeParams + '\'' + ", returnType='" + this.returnType + '\'' + ", parameters=" + (this.parameters == null ? null : Arrays.toString(this.parameters)) + '}';
    }
}

