/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder.spock;

import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.TestNameSnifferHelper;
import com_atlassian_clover.TestNameSniffer;
import java.lang.reflect.Method;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.IterationInfo;

public class CloverSpockIterationInterceptor
implements IMethodInterceptor {
    public void intercept(IMethodInvocation invocation) throws Throwable {
        if (invocation.getIteration() != null) {
            IterationInfo iterationInfo;
            Logger.getInstance().debug("CloverSpockIterationInterceptor: Spock is about to call: \"" + invocation.getFeature().getName() + "\" (" + ((Method)invocation.getFeature().getFeatureMethod().getReflection()).toString() + ")");
            TestNameSniffer spockSniffer = TestNameSnifferHelper.lookupTestSnifferField(invocation.getInstance().getClass());
            if (spockSniffer != null && (iterationInfo = invocation.getIteration()) != null) {
                Logger.getInstance().debug("CloverSpockIterationInterceptor test name=" + iterationInfo.getName() + " method name=" + invocation.getMethod().getName());
                spockSniffer.setTestName(iterationInfo.getName());
            }
        }
        invocation.proceed();
    }
}

