/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEditorProvider
implements ApplicationComponent,
FileEditorProvider {
    private final String editorName;

    protected AbstractEditorProvider(String editorName) {
        this.editorName = editorName;
    }

    public void disposeEditor(@NotNull FileEditor fileEditor) {
        Disposer.dispose((Disposable)fileEditor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile virtualFile) {
        return new FileEditorState(){

            public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
                return false;
            }
        };
    }

    public void writeState(@NotNull FileEditorState fileEditorState, @NotNull Project project, @NotNull Element element) {
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        return this.editorName + "Report";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return this.editorName + "EditorProvider";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

