/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.testexplorer.DecoratedTestCaseInfo;
import com.atlassian.clover.idea.testexplorer.SimplePackageFragment;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeSelectionHelper {
    final Object selectedElement;

    public TreeSelectionHelper(JTree origTree) {
        TreePath currentSelection = origTree.getSelectionPath();
        DefaultMutableTreeNode selectedNode = currentSelection == null ? null : (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
        this.selectedElement = selectedNode == null ? new Object() : TreeSelectionHelper.getWrapperObject(selectedNode.getUserObject());
    }

    public void restore(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> children = root.depthFirstEnumeration();
        TreePath selectionPath = null;
        while (children.hasMoreElements() && selectionPath == null) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            Object wrappedObject = TreeSelectionHelper.getWrapperObject(child.getUserObject());
            if (!this.selectedElement.equals(wrappedObject)) continue;
            selectionPath = new TreePath(child.getPath());
        }
        if (selectionPath != null) {
            tree.setSelectionPath(selectionPath);
        }
    }

    static Object getWrapperObject(Object o) {
        if (o instanceof CoverageTreeModel.NodeWrapper) {
            return TreeSelectionHelper.getWrapperObject(((CoverageTreeModel.NodeWrapper)o).getHasMetrics());
        }
        if (o instanceof PackageFragment) {
            return new PackageWrapper((PackageFragment)o);
        }
        if (o instanceof FullPackageInfo) {
            return new PackageWrapper((FullPackageInfo)o);
        }
        if (o instanceof SimplePackageFragment) {
            return new PackageWrapper((SimplePackageFragment)o);
        }
        if (o instanceof DecoratedTestCaseInfo) {
            return ((DecoratedTestCaseInfo)o).getNakedTestCaseInfo();
        }
        return o;
    }

    private static class PackageWrapper {
        private final Object packageName;

        PackageWrapper(PackageFragment packageFragment) {
            this.packageName = packageFragment.getQualifiedName();
        }

        private PackageWrapper(FullPackageInfo packageInfo) {
            this.packageName = packageInfo.getName();
        }

        private PackageWrapper(SimplePackageFragment simplePackageFragment) {
            FullPackageInfo concrete = simplePackageFragment.getConcretePackage();
            this.packageName = concrete != null ? concrete.getName() : new Object();
        }

        public boolean equals(Object obj) {
            return obj instanceof PackageWrapper && this.packageName.equals(((PackageWrapper)obj).packageName);
        }

        public int hashCode() {
            return this.packageName.hashCode();
        }
    }
}

