/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nullable;

public class ExceptionDialog
extends DialogWrapper {
    private final String description;
    private final String question;
    private final String exceptionStr;
    private final String exceptionTitle;
    private final boolean isYesNoDialog;
    private JComponent exceptionPane;
    private final JPanel thePanel = new JPanel();
    private CellConstraints exceptionCC;

    protected ExceptionDialog(@Nullable Project project, String description, String question, Throwable exception, String title, boolean yesNoDialog) {
        super(project, false);
        this.description = description;
        this.question = question;
        this.isYesNoDialog = yesNoDialog;
        this.exceptionStr = ExceptionDialog.getExceptionString(exception);
        this.exceptionTitle = exception.getLocalizedMessage();
        this.setTitle(title);
        this.init();
    }

    public static int showYesNoDialog(Project project, String description, String question, Throwable exception, String title) {
        ExceptionDialog dialog = new ExceptionDialog(project, description, question, exception, title, true);
        dialog.show();
        return dialog.getExitCode();
    }

    public static void showOKDialog(@Nullable Project project, String description, String question, Throwable exception, String title) {
        ExceptionDialog dialog = new ExceptionDialog(project, description, question, exception, title, false);
        dialog.show();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, 15dlu, 300dlu, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 9dlu");
        CellConstraints iconCC = new CellConstraints(2, 2, 1, 5);
        CellConstraints descrCC = new CellConstraints(4, 2, 2, 1);
        CellConstraints exceptionTitleCC = new CellConstraints(5, 4, 1, 1);
        this.exceptionCC = new CellConstraints(5, 6, 1, 1);
        CellConstraints questionCC = new CellConstraints(4, 8, 2, 1);
        this.thePanel.setLayout((LayoutManager)formLayout);
        JLabel iconLabel = new JLabel(Messages.getQuestionIcon());
        iconLabel.setVerticalAlignment(1);
        this.thePanel.add((Component)iconLabel, iconCC);
        JTextArea descrArea = new JTextArea(this.description);
        descrArea.setEditable(false);
        descrArea.setBackground(UIUtil.getOptionPaneBackground());
        this.thePanel.add((Component)descrArea, descrCC);
        JLabel exTitleLabel = new JLabel(this.exceptionTitle);
        exTitleLabel.setFont(exTitleLabel.getFont().deriveFont(2));
        this.thePanel.add((Component)exTitleLabel, exceptionTitleCC);
        JTextArea exceptionArea = new JTextArea(10, 60);
        exceptionArea.setText(this.exceptionStr);
        exceptionArea.setEditable(false);
        exceptionArea.setCaretPosition(0);
        exceptionArea.setTabSize(2);
        this.exceptionPane = new JScrollPane(exceptionArea);
        JTextArea questionArea = new JTextArea(this.question);
        questionArea.setEditable(false);
        questionArea.setBackground(UIUtil.getOptionPaneBackground());
        this.thePanel.add((Component)questionArea, questionCC);
        return this.thePanel;
    }

    protected Action[] createActions() {
        Action[] actionArray;
        if (this.isYesNoDialog) {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = new DetailsAction();
            actionArray2[1] = this.getOKAction();
            actionArray = actionArray2;
            actionArray2[2] = this.getCancelAction();
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = new DetailsAction();
            actionArray = actionArray3;
            actionArray3[1] = this.getOKAction();
        }
        return actionArray;
    }

    private static String getExceptionString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }

    private class DetailsAction
    extends AbstractAction {
        private static final String SHOW_TXT = "Show Exception Details";
        private static final String HIDE_TXT = "Hide Exception Details";

        public DetailsAction() {
            this.putValue("Name", SHOW_TXT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExceptionDialog.this.exceptionPane.getParent() != null) {
                ExceptionDialog.this.thePanel.remove(ExceptionDialog.this.exceptionPane);
                this.putValue("Name", SHOW_TXT);
            } else {
                ExceptionDialog.this.thePanel.add((Component)ExceptionDialog.this.exceptionPane, ExceptionDialog.this.exceptionCC);
                this.putValue("Name", HIDE_TXT);
            }
            ExceptionDialog.this.pack();
        }
    }
}

