/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import org.openclover.util.Maps;

public class BorderLayoutConverter
extends BorderLayout {
    private final Map<Component, String> storedComponentMap = Maps.newHashMap();
    private final Component layoutComponent;
    private boolean freeze;
    private boolean doFlip;
    private static final Map<String, String> TRANSLATION = new HashMap<String, String>(){
        {
            this.put("North", "West");
            this.put("West", "North");
            this.put("Center", "Center");
            this.put("South", "East");
            this.put("East", "South");
        }
    };

    public BorderLayoutConverter(Component component) {
        this.layoutComponent = component;
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dimension = e.getComponent().getSize();
                BorderLayoutConverter.this.setFlip(dimension.getWidth() > dimension.getHeight() * 1.25);
            }
        });
    }

    @Override
    @Deprecated
    public void addLayoutComponent(String name, Component comp) {
        if (!this.freeze) {
            this.storedComponentMap.put(comp, name);
        }
        super.addLayoutComponent(name, comp);
    }

    public void setFlip(boolean flip) {
        if (flip == this.doFlip) {
            return;
        }
        this.freeze = true;
        this.doFlip = flip;
        for (Map.Entry<Component, String> entry : this.storedComponentMap.entrySet()) {
            Component component = entry.getKey();
            String constraint = flip ? TRANSLATION.get(entry.getValue()) : entry.getValue();
            this.removeLayoutComponent(component);
            this.addLayoutComponent(component, constraint);
        }
        this.layoutComponent.invalidate();
    }
}

