/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.jdom;

import com.atlassian.clover.idea.util.jdom.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import org.openclover.util.Maps;

public class PropertyUtil {
    public static final Object getPropertyValue(String propertyName, Object obj) {
        String methodName = "is" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Class[] paramTypes = new Class[]{};
        Method getter = null;
        try {
            getter = obj.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                methodName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
                getter = obj.getClass().getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (getter == null) {
            // empty if block
        }
        try {
            return getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static Property[] getProperties(Class cls) {
        Method[] methods;
        HashMap properties = Maps.newHashMap();
        for (Method method : methods = cls.getMethods()) {
            if (!PropertyUtil.isAccessor(method)) continue;
            Property property = PropertyUtil.getProperty(method);
            String key = property.getName() + ":" + property.getType().getName();
            if (!properties.containsKey(key)) {
                properties.put(key, property);
                continue;
            }
            Property otherProperty = (Property)properties.get(key);
            otherProperty.merge(property);
        }
        return properties.values().toArray(new Property[properties.size()]);
    }

    public static Property[] getProperties(Object obj) {
        if (obj == null) {
            return new Property[0];
        }
        return PropertyUtil.getProperties(obj.getClass());
    }

    private static boolean isAccessor(Method m) {
        String methodName = m.getName();
        String propName = null;
        if (methodName.startsWith("get")) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("set")) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring(2);
        } else {
            return false;
        }
        if (propName.length() == 0) {
            return false;
        }
        if (methodName.startsWith("get") || methodName.startsWith("is")) {
            if (m.getReturnType() == null) {
                return false;
            }
            if (m.getParameterTypes().length > 0) {
                return false;
            }
        } else {
            if (m.getReturnType() != Void.TYPE) {
                return false;
            }
            if (m.getParameterTypes().length != 1) {
                return false;
            }
        }
        return Character.isUpperCase(propName.charAt(0));
    }

    private static Property getProperty(Method m) {
        String methodName = m.getName();
        String propName = null;
        Class<?> type = null;
        boolean isGetter = false;
        if (methodName.startsWith("get")) {
            propName = methodName.substring(3);
            type = m.getReturnType();
            isGetter = true;
        } else if (methodName.startsWith("set")) {
            propName = methodName.substring(3);
            type = m.getParameterTypes()[0];
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring(2);
            type = m.getReturnType();
            isGetter = true;
        }
        propName = propName.length() == 1 ? propName.toLowerCase() : propName.substring(0, 1).toLowerCase() + propName.substring(1);
        Property property = new Property(propName, type);
        if (isGetter) {
            property.setGetterMethod(m);
        } else {
            property.setSetterMethod(m);
        }
        return property;
    }
}

