/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.jdom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Property {
    private final String name;
    private final Class type;
    private boolean readable;
    private boolean writeable;
    private Method getterMethod;
    private Method setterMethod;

    public Property(String propertyName, Class propertyType) {
        this.name = propertyName;
        this.type = propertyType;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue(Object obj) throws IllegalAccessException, InvocationTargetException {
        if (!this.isReadable()) {
            throw new IllegalArgumentException("Property " + this.name + " is not readable.");
        }
        this.getterMethod.setAccessible(true);
        return this.getterMethod.invoke(obj, new Object[0]);
    }

    public void setValue(Object obj, Object val) throws IllegalAccessException, InvocationTargetException {
        if (!this.isWriteable()) {
            throw new IllegalArgumentException("Property " + this.name + " is not writable.");
        }
        this.setterMethod.setAccessible(true);
        this.setterMethod.invoke(obj, val);
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setSetterMethod(Method m) {
        this.setterMethod = m;
        this.writeable = true;
    }

    public void setGetterMethod(Method m) {
        this.getterMethod = m;
        this.readable = true;
    }

    public void merge(Property otherProperty) {
        if (!this.name.equals(otherProperty.name)) {
            throw new IllegalArgumentException("Can not merge properties with different names: (" + this.name + ", " + otherProperty.name + ").");
        }
        if (!this.type.equals(otherProperty.type)) {
            throw new IllegalArgumentException("Can not merge properties with different types: (" + this.type + ", " + otherProperty.type + ")");
        }
        if (otherProperty.getterMethod != null && !this.readable) {
            this.setGetterMethod(otherProperty.getterMethod);
        }
        if (otherProperty.setterMethod != null && !this.writeable) {
            this.setSetterMethod(otherProperty.setterMethod);
        }
    }
}

