/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util;

import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ProjectUtil {
    private ProjectUtil() {
    }

    public static File getProjectWorkspace(Project project) {
        return new File(ProjectUtil.getProjectDirectory(project), ".clover");
    }

    @NotNull
    public static File getProjectDirectory(final Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project argument can not be null.");
        }
        Application app = ApplicationManager.getApplication();
        return (File)app.runReadAction((Computable)new Computable<File>(){

            public File compute() {
                VirtualFile baseDir = project.getBaseDir();
                String basePath = baseDir != null ? baseDir.getPath() : FileUtil.getTempDirectory();
                return new File(basePath);
            }
        });
    }

    public static File getModuleWorkspace(final Module module) {
        Application app = ApplicationManager.getApplication();
        return (File)app.runReadAction((Computable)new Computable<File>(){

            public File compute() {
                File projectWksp = ProjectUtil.getProjectWorkspace(module.getProject());
                return new File(projectWksp, module.getName());
            }
        });
    }

    public static boolean excludeFromProject(Project project, VirtualFile excludedDir) {
        ModuleManager mManager = ModuleManager.getInstance((Project)project);
        Module[] modules = mManager.getModules();
        boolean modified = false;
        for (Module module : modules) {
            ModuleRootManager rManager = ModuleRootManager.getInstance((Module)module);
            if (!rManager.getFileIndex().isInContent(excludedDir) || !ProjectUtil.needsAddingExcludes(rManager, excludedDir)) continue;
            ModifiableRootModel rootModel = rManager.getModifiableModel();
            for (ContentEntry modifiableEntry : rootModel.getContentEntries()) {
                if (!ProjectUtil.needsAddingAnExclude(modifiableEntry, excludedDir)) continue;
                modifiableEntry.addExcludeFolder(excludedDir);
            }
            rootModel.commit();
            modified = true;
        }
        return modified;
    }

    private static boolean needsAddingExcludes(ModuleRootManager rManager, VirtualFile excludedDir) {
        for (ContentEntry entry : rManager.getContentEntries()) {
            if (!ProjectUtil.needsAddingAnExclude(entry, excludedDir)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsAddingAnExclude(ContentEntry entry, VirtualFile excludedDir) {
        VirtualFile contentEntryFile = entry.getFile();
        return !Arrays.asList(entry.getExcludeFolderFiles()).contains(excludedDir) && contentEntryFile != null && VfsUtil.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)excludedDir, (boolean)false);
    }
}

