/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util;

import java.util.List;

public class ComparatorUtil {
    private ComparatorUtil() {
    }

    public static <T> int compare(Comparable<T> arg1, T arg2) {
        if (arg1 == null) {
            return arg2 == null ? 0 : -1;
        }
        return arg2 == null ? 1 : arg1.compareTo(arg2);
    }

    public static <T> int compareNE(Comparable<T> arg1, T arg2) {
        return arg1 == null || arg2 == null ? 0 : arg1.compareTo(arg2);
    }

    public static int compareLong(long arg1, long arg2) {
        return Long.compare(arg1, arg2);
    }

    public static boolean areEqual(Object obj, Object obj1) {
        if (obj == obj1) {
            return true;
        }
        if (obj == null || obj1 == null) {
            return false;
        }
        return obj.equals(obj1);
    }

    public static boolean areEqual(List a, List b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (ComparatorUtil.areEqual(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areDifferent(Object obj, Object obj1) {
        return !ComparatorUtil.areEqual(obj, obj1);
    }
}

