/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetUtil {
    private CharsetUtil() {
    }

    @Nullable
    public static String getSystemDefaultEncoding() {
        Charset systemCharset = CharsetToolkit.getDefaultSystemCharset();
        return systemCharset != null ? systemCharset.name() : null;
    }

    @Nullable
    public static String getIdeDefaultEncoding() {
        String systemCharsetName = CharsetUtil.getSystemDefaultEncoding();
        Charset ideCharset = EncodingManager.getInstance().getDefaultCharset();
        return ideCharset != null ? ideCharset.name() : systemCharsetName;
    }

    @Nullable
    public static String getProjectDefaultEncoding() {
        String systemCharsetName = CharsetUtil.getSystemDefaultEncoding();
        Charset projectCharset = EncodingProjectManager.getInstance().getDefaultCharset();
        return projectCharset != null ? projectCharset.name() : systemCharsetName;
    }

    public static String getFileEncoding(@NotNull VirtualFile virtualFile) {
        Charset fileCharset = EncodingManager.getInstance().getEncoding(virtualFile, true);
        String projectCharsetName = CharsetUtil.getProjectDefaultEncoding();
        return fileCharset != null ? fileCharset.name() : projectCharsetName;
    }
}

