/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.treetables;

import com.atlassian.clover.idea.treetables.ProjectTreeCellRenderer;
import com.atlassian.clover.idea.treetables.SortableListTreeTableModelOnColumns;
import com.atlassian.clover.idea.util.ui.ScrollToSourceMouseAdapter;
import com.atlassian.clover.idea.util.ui.TreeExpansionHelper;
import com.atlassian.clover.idea.util.ui.TreeSelectionHelper;
import com.atlassian.clover.idea.util.ui.TreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTablePanel
extends JPanel {
    protected final TreeTableView treeTableView;
    protected final DefaultMutableTreeNode rootNode;
    protected final SortableListTreeTableModelOnColumns tableModel;
    protected boolean alwaysExpandTestCases;
    protected boolean alwaysCollapseTestCases;

    public TreeTablePanel(Project project, SortableListTreeTableModelOnColumns model) {
        this.setLayout(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode();
        this.tableModel = model;
        this.tableModel.setRoot(this.rootNode);
        this.treeTableView = new TreeTableView((ListTreeTableModelOnColumns)this.tableModel);
        this.treeTableView.setRootVisible(false);
        this.treeTableView.setTreeCellRenderer((TreeCellRenderer)new ProjectTreeCellRenderer());
        this.treeTableView.getTree().setShowsRootHandles(true);
        this.treeTableView.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        this.treeTableView.setSelectionMode(0);
        this.treeTableView.setAutoResizeMode(0);
        this.treeTableView.setAutoscrolls(true);
        this.treeTableView.addMouseListener((MouseListener)ScrollToSourceMouseAdapter.getInstance(project));
        this.treeTableView.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = TreeTablePanel.this.treeTableView.getTableHeader().getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                int modelColumn = columnModel.getColumn(column).getModelIndex();
                TreeTablePanel.this.tableModel.sortByColumn(modelColumn);
                TreeTablePanel.this.sortNodes();
            }
        });
    }

    public void clean() {
        this.rootNode.removeAllChildren();
        this.tableModel.nodeStructureChanged(this.rootNode);
    }

    protected void expandAll(boolean expand) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.tableModel.getRoot();
        Enumeration<TreeNode> nodes = rootNode.postorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)nodes.nextElement();
            if (child == rootNode || child.isLeaf()) continue;
            TreePath path = new TreePath(child.getPath());
            if (expand) {
                this.treeTableView.getTree().expandPath(path);
                continue;
            }
            this.treeTableView.getTree().collapsePath(path);
        }
    }

    protected void sortNodes() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.tableModel.getRoot();
        boolean customExpand = !this.alwaysExpandTestCases && !this.alwaysCollapseTestCases;
        TreeSelectionHelper teh = customExpand ? new TreeExpansionHelper((JTree)this.treeTableView.getTree()) : new TreeSelectionHelper((JTree)this.treeTableView.getTree());
        TreeUtil.sortNodes(rootNode, this.tableModel);
        this.tableModel.reload();
        if (!customExpand && this.alwaysExpandTestCases) {
            this.expandAll(true);
        }
        teh.restore((JTree)this.treeTableView.getTree());
    }
}

