/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.idea.testexplorer.AbstractTestCaseNodeComparator;
import com.atlassian.clover.idea.treetables.AbstractColumnInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;

public class TestStatusColumnInfo
extends AbstractColumnInfo<DefaultMutableTreeNode> {
    private static final TableCellRenderer STATUS_CELL_RENDERER = new DefaultTableCellRenderer(){
        private Color colorOverride;
        {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof TestCaseInfo) {
                Status status = Status.resolve((TestCaseInfo)userObject);
                this.setText(status.toString());
                this.colorOverride = status.getColor();
            } else {
                this.setText("");
                this.colorOverride = null;
            }
            return this;
        }

        @Override
        public boolean isOpaque() {
            return this.colorOverride != null || super.isOpaque();
        }

        @Override
        public Color getBackground() {
            return this.colorOverride != null ? this.colorOverride : super.getBackground();
        }
    };
    private static final Comparator<DefaultMutableTreeNode> COMPARATOR = new AbstractTestCaseNodeComparator(){

        @Override
        int compare(TestCaseInfo tci1, TestCaseInfo tci2) {
            Status status1 = Status.resolve(tci1);
            Status status2 = Status.resolve(tci2);
            return status1.compareTo(status2);
        }
    };

    public TestStatusColumnInfo() {
        super("Status", STATUS_CELL_RENDERER);
    }

    public DefaultMutableTreeNode valueOf(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode;
    }

    public int getWidth(JTable jTable) {
        return this.getWidth(jTable, " ERROR ");
    }

    public Comparator<DefaultMutableTreeNode> getComparator() {
        return COMPARATOR;
    }

    private static enum Status {
        NA(null){

            public String toString() {
                return "";
            }
        }
        ,
        PASS(Color.GREEN),
        FAIL(Color.RED),
        ERROR(Color.ORANGE);

        private final Color color;

        private Status(Color color) {
            this.color = color;
        }

        Color getColor() {
            return this.color;
        }

        static Status resolve(TestCaseInfo tci) {
            if (tci == null) {
                return NA;
            }
            if (tci.isSuccess()) {
                return PASS;
            }
            if (tci.isError()) {
                return ERROR;
            }
            if (tci.isFailure()) {
                return FAIL;
            }
            return NA;
        }
    }
}

