/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.TestCaseLayout;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.testexplorer.DecoratedTestCaseInfo;
import com.atlassian.clover.idea.testexplorer.SourceFolderDescription;
import com.atlassian.clover.idea.treetables.SortableListTreeTableModelOnColumns;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class TestRunExplorerTreeBuilder {
    private final Project project;
    private final SortableListTreeTableModelOnColumns sortableModel;
    private final DefaultMutableTreeNode rootNode;
    private WeakReference<BackgroundCoverageCalculator> lastCalculator;

    public TestRunExplorerTreeBuilder(Project project, SortableListTreeTableModelOnColumns sortableModel, DefaultMutableTreeNode rootNode) {
        this.project = project;
        this.sortableModel = sortableModel;
        this.rootNode = rootNode;
    }

    private Map<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> indexPerPackage(Collection<? extends TestCaseInfo> testCases) {
        IdentityHashMap<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> index = new IdentityHashMap<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>>();
        for (TestCaseInfo testCaseInfo : testCases) {
            ArrayList tciList;
            FullClassInfo classInfo = testCaseInfo.getRuntimeType();
            if (classInfo == null) continue;
            PackageInfo packageInfo = classInfo.getPackage();
            IdentityHashMap clsMap = (IdentityHashMap)index.get(packageInfo);
            if (clsMap == null) {
                clsMap = new IdentityHashMap();
                index.put(packageInfo, clsMap);
                tciList = null;
            } else {
                tciList = (ArrayList)clsMap.get(classInfo);
            }
            if (tciList == null) {
                tciList = Lists.newArrayList();
                clsMap.put(classInfo, tciList);
            }
            tciList.add(testCaseInfo);
        }
        return index;
    }

    private Map<SourceFolderDescription, Collection<TestCaseInfo>> sortBySourceRoot(Collection<? extends TestCaseInfo> testCases) {
        ArrayList<SourceFolder> sourceFolders = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)this.project).getModules()) {
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                sourceFolders.addAll(Arrays.asList(contentEntry.getSourceFolders()));
            }
        }
        HashMap<SourceFolderDescription, Collection<TestCaseInfo>> map = Maps.newHashMap();
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile sourceVirtualFile = sourceFolder.getFile();
            if (sourceVirtualFile == null) continue;
            SourceFolderDescription sourceFolderDescription = new SourceFolderDescription(VfsUtil.calcRelativeToProjectPath(sourceVirtualFile, this.project), sourceFolder.isTestSource());
            ArrayList perFolder = Lists.newArrayList();
            File rootDir = com.intellij.openapi.vfs.VfsUtil.virtualToIoFile((VirtualFile)sourceVirtualFile);
            for (TestCaseInfo testCaseInfo : testCases) {
                File file = ((FullFileInfo)testCaseInfo.getRuntimeType().getContainingFile()).getPhysicalFile();
                if (!com.intellij.openapi.vfs.VfsUtil.isAncestor((File)rootDir, (File)file, (boolean)false)) continue;
                perFolder.add(testCaseInfo);
            }
            if (perFolder.isEmpty()) continue;
            map.put(sourceFolderDescription, perFolder);
        }
        return map;
    }

    private void addSourceRoots(DefaultMutableTreeNode rootNode, Collection<? extends TestCaseInfo> testCases, boolean flat, CloverDatabase cloverDatabase) {
        Map<SourceFolderDescription, Collection<TestCaseInfo>> srcRootIndex = this.sortBySourceRoot(testCases);
        for (Map.Entry<SourceFolderDescription, Collection<TestCaseInfo>> entry : srcRootIndex.entrySet()) {
            DefaultMutableTreeNode srcRootNode = new DefaultMutableTreeNode(entry.getKey());
            rootNode.add(srcRootNode);
            if (flat) {
                this.addFlatPackages(srcRootNode, entry.getValue());
                continue;
            }
            this.addPackageFragments(srcRootNode, entry.getValue(), cloverDatabase);
        }
    }

    private void addFlatPackages(DefaultMutableTreeNode rootNode, Collection<? extends TestCaseInfo> testCases) {
        Map<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> index = this.indexPerPackage(testCases);
        for (Map.Entry<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> entry : index.entrySet()) {
            PackageInfo packageInfo = entry.getKey();
            DefaultMutableTreeNode packageNode = new DefaultMutableTreeNode(packageInfo);
            rootNode.add(packageNode);
            this.addClasses(entry.getValue(), packageNode);
        }
    }

    private void addClasses(Map<FullClassInfo, Collection<TestCaseInfo>> classes, DefaultMutableTreeNode packageNode) {
        for (Map.Entry<FullClassInfo, Collection<TestCaseInfo>> entry : classes.entrySet()) {
            FullClassInfo classInfo = entry.getKey();
            Collection<TestCaseInfo> classCases = entry.getValue();
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(classInfo);
            packageNode.add(classNode);
            this.addSorted(classNode, classCases);
        }
    }

    private void addPackageFragments(DefaultMutableTreeNode rootNode, Collection<? extends TestCaseInfo> testCases, CloverDatabase cloverDatabase) {
        PackageFragment[] packageRoots;
        Map<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> index = this.indexPerPackage(testCases);
        for (PackageFragment packageRoot : packageRoots = cloverDatabase.getFullModel().getPackageRoots()) {
            DefaultMutableTreeNode childNode = this.getPackageFragmentNode(index, packageRoot);
            if (childNode == null) continue;
            rootNode.add(childNode);
        }
    }

    private DefaultMutableTreeNode getPackageFragmentNode(Map<PackageInfo, Map<FullClassInfo, Collection<TestCaseInfo>>> index, PackageFragment packageFragment) {
        FullPackageInfo concrete;
        Map<FullClassInfo, Collection<TestCaseInfo>> classes;
        DefaultMutableTreeNode node = null;
        for (PackageFragment fragment : packageFragment.getChildren()) {
            DefaultMutableTreeNode childNode = this.getPackageFragmentNode(index, fragment);
            if (childNode == null) continue;
            if (node == null) {
                node = new DefaultMutableTreeNode(packageFragment);
            }
            node.add(childNode);
        }
        if (packageFragment.isConcrete() && (classes = index.get(concrete = packageFragment.getConcretePackage())) != null) {
            if (node == null) {
                node = new DefaultMutableTreeNode(packageFragment);
            }
            this.addClasses(classes, node);
        }
        return node;
    }

    public static Collection<DecoratedTestCaseInfo> wrap(Collection<? extends TestCaseInfo> testCases, CoverageDataReceptor receptor, CloverDatabase currentDatabase, CoverageManager coverageManager) {
        ArrayList<DecoratedTestCaseInfo> decorated = new ArrayList<DecoratedTestCaseInfo>(testCases.size());
        for (TestCaseInfo testCaseInfo : testCases) {
            decorated.add(new DecoratedTestCaseInfo(testCaseInfo, receptor, currentDatabase, coverageManager));
        }
        return decorated;
    }

    void populate(CloverDatabase currentDatabase, CoverageDataReceptor receptor, TestCaseLayout layout, boolean flatten, boolean addCoverage) {
        Collection<TestCaseInfo> testCases;
        Set<TestCaseInfo> set = testCases = receptor instanceof FullProjectInfo ? currentDatabase.getCoverageData().getTests() : currentDatabase.getTestHits(receptor);
        if (addCoverage && receptor instanceof HasMetrics) {
            CoverageManager coverageManager = ProjectPlugin.getPlugin(this.project).getCoverageManager();
            testCases = TestRunExplorerTreeBuilder.wrap(testCases, receptor, currentDatabase, coverageManager);
        }
        this.populate(currentDatabase, testCases, layout, flatten);
    }

    private void scheduleCalculator(Collection<DecoratedTestCaseInfo> testCases, CoverageDataReceptor receptor, CloverDatabase currentDatabase) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (WindowManager.getInstance().getFrame(this.project) != null) {
            BackgroundCoverageCalculator calculator = new BackgroundCoverageCalculator(testCases, receptor, currentDatabase);
            this.lastCalculator = new WeakReference<BackgroundCoverageCalculator>(calculator);
            calculator.queue();
        }
    }

    void cancelLastCalculator() {
        BackgroundCoverageCalculator last;
        ApplicationManager.getApplication().assertIsDispatchThread();
        BackgroundCoverageCalculator backgroundCoverageCalculator = last = this.lastCalculator != null ? (BackgroundCoverageCalculator)((Object)this.lastCalculator.get()) : null;
        if (last != null) {
            last.cancel();
        }
    }

    void populate(CloverDatabase currentDatabase, Collection<? extends TestCaseInfo> testCases, TestCaseLayout layout, boolean flatten) {
        switch (layout) {
            case TEST_CASES: {
                this.addSorted(this.rootNode, testCases);
                break;
            }
            case PACKAGES: {
                if (flatten) {
                    this.addFlatPackages(this.rootNode, testCases);
                    break;
                }
                this.addPackageFragments(this.rootNode, testCases, currentDatabase);
                break;
            }
            case SOURCE_ROOTS: {
                this.addSourceRoots(this.rootNode, testCases, flatten, currentDatabase);
            }
        }
    }

    private void addSorted(DefaultMutableTreeNode root, Collection<? extends TestCaseInfo> testCases) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(testCases.size());
        for (TestCaseInfo testCaseInfo : testCases) {
            final DefaultMutableTreeNode node = new DefaultMutableTreeNode(testCaseInfo);
            nodes.add(node);
            if (!(testCaseInfo instanceof DecoratedTestCaseInfo)) continue;
            ((DecoratedTestCaseInfo)testCaseInfo).setAsyncUpdate(new Runnable(){

                @Override
                public void run() {
                    TestRunExplorerTreeBuilder.this.sortableModel.nodeChanged(node);
                }
            });
        }
        this.sortableModel.sortNodes(nodes);
        for (DefaultMutableTreeNode defaultMutableTreeNode : nodes) {
            root.add(defaultMutableTreeNode);
        }
    }

    public class BackgroundCoverageCalculator
    extends Task.Backgroundable {
        private ProgressIndicator progressIndicator;
        private boolean alreadyCancelled;
        private final Collection<DecoratedTestCaseInfo> testCases;
        private final CoverageDataReceptor receptor;
        private final CloverDatabase cloverDatabase;

        public BackgroundCoverageCalculator(Collection<DecoratedTestCaseInfo> testCases, CoverageDataReceptor receptor, CloverDatabase cloverDatabase) {
            super(TestRunExplorerTreeBuilder.this.project, "Calculating per-test coverage");
            this.testCases = testCases;
            this.receptor = receptor;
            this.cloverDatabase = cloverDatabase;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.setProgressIndicator(indicator);
            indicator.setIndeterminate(true);
            indicator.setText2("Copying receptor data");
            CoverageDataReceptor receptorCopy = this.copyReceptor(this.receptor);
            indicator.setText2("Indexing per test coverage");
            int step = this.testCases.size() / 100 + 1;
            int counter = 0;
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.setText2("Calculating per test coverage");
            for (DecoratedTestCaseInfo testCase : this.testCases) {
                Set<TestCaseInfo> testSet = Collections.singleton(testCase.getNakedTestCaseInfo());
                CoverageData data = this.cloverDatabase.getCoverageData();
                BitSet testCoverage = data.getHitsFor(testSet, this.receptor);
                BitSetCoverageProvider dataProvider = new BitSetCoverageProvider(testCoverage, data);
                receptorCopy.setDataProvider(dataProvider);
                float coverage = ((HasMetrics)((Object)receptorCopy)).getMetrics().getPcCoveredElements();
                testCoverage.and(this.cloverDatabase.getCoverageData().getUniqueHitsFor(testCase.getNakedTestCaseInfo()));
                receptorCopy.setDataProvider(dataProvider);
                float uniqueCoverage = ((HasMetrics)((Object)receptorCopy)).getMetrics().getPcCoveredElements();
                testCase.setCoverage(coverage);
                testCase.setUniqueCoverage(uniqueCoverage);
                indicator.checkCanceled();
                if (++counter % step != 0) continue;
                indicator.setFraction((double)counter / (double)this.testCases.size());
            }
        }

        public void onSuccess() {
            TestRunExplorerTreeBuilder.this.sortableModel.nodesChanged(TestRunExplorerTreeBuilder.this.rootNode, null);
        }

        public void onCancel() {
            TestRunExplorerTreeBuilder.this.sortableModel.nodesChanged(TestRunExplorerTreeBuilder.this.rootNode, null);
        }

        private CoverageDataReceptor copyReceptor(CoverageDataReceptor receptor) {
            if (receptor instanceof FullProjectInfo) {
                return ((FullProjectInfo)receptor).copy();
            }
            if (receptor instanceof FullFileInfo) {
                FullFileInfo fileInfo = (FullFileInfo)receptor;
                return fileInfo.copy((FullPackageInfo)fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
            }
            if (receptor instanceof FullClassInfo) {
                FullClassInfo classInfo = (FullClassInfo)receptor;
                return classInfo.copy((FullFileInfo)classInfo.getContainingFile(), HasMetricsFilter.ACCEPT_ALL);
            }
            if (receptor instanceof FullMethodInfo) {
                FullMethodInfo methodInfo = (FullMethodInfo)receptor;
                if (methodInfo.getContainingClass() != null) {
                    return methodInfo.copy((FullClassInfo)methodInfo.getContainingClass());
                }
                if (methodInfo.getContainingMethod() != null) {
                    return methodInfo.copy((FullMethodInfo)methodInfo.getContainingMethod());
                }
                return methodInfo.copy((FullFileInfo)methodInfo.getContainingFile());
            }
            return null;
        }

        private synchronized void setProgressIndicator(ProgressIndicator indicator) throws ProcessCanceledException {
            if (this.alreadyCancelled) {
                throw new ProcessCanceledException();
            }
            this.progressIndicator = indicator;
        }

        public synchronized void cancel() {
            this.alreadyCancelled = true;
            if (this.progressIndicator != null) {
                this.progressIndicator.cancel();
            }
        }
    }
}

