/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.SelectInCloverTarget;
import com.atlassian.clover.idea.SelectInCloverView;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.TestCaseLayout;
import com.atlassian.clover.idea.config.TestViewScope;
import com.atlassian.clover.idea.content.StatementsAggregatingVisitor;
import com.atlassian.clover.idea.coverage.CoverageListener;
import com.atlassian.clover.idea.coverage.EventListenerInstallator;
import com.atlassian.clover.idea.testexplorer.CoverageContributionPanel;
import com.atlassian.clover.idea.testexplorer.TestRunBrowserPanel;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunExplorerToolWindow
extends JPanel
implements CoverageListener,
ConfigChangeListener,
FileEditorManagerListener,
CaretListener {
    public static final String TOOL_WINDOW_ID = "Test Runs";
    private static final String TOOL_WINDOW_NAME = "Explorer";
    private static final Key<TestRunExplorerToolWindow> WINDOW_PROJECT_KEY = Key.create((String)TestRunExplorerToolWindow.class.getName());
    private ToolWindow toolWindow;
    private final Project project;
    private final TestRunBrowserPanel testRunBrowserPanel;
    private boolean flattenPackages;
    private TestCaseLayout testCaseLayout;
    private final SelectInCloverHandler selectInCloverHandler = new SelectInCloverHandler();
    private CloverDatabase currentCloverDatabase;
    private TestViewScope testViewScope;
    private boolean calculateCoverage;
    private static final CoverageDataReceptor NULL_MARKER = new FullProjectInfo("NULL MARKER");
    private WeakReference<CoverageDataReceptor> previousReceptor;
    private boolean prevCoverageCalculated;
    private boolean prevFlattenPackages;
    private TestCaseLayout prevTestCaseLayout;
    private boolean scheduledCalculationPending;

    TestRunExplorerToolWindow(Project project) {
        this.project = project;
        this.setLayout(new BorderLayout());
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("CloverPlugin.TestExplorerToolBar");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CloverTestExplorer", actionGroup, true);
        this.add((Component)toolbar.getComponent(), "North");
        CoverageContributionPanel coverageContributionPanel = new CoverageContributionPanel(project);
        this.testRunBrowserPanel = new TestRunBrowserPanel(project);
        this.testRunBrowserPanel.addTestCaseSelectionListener(coverageContributionPanel);
        final Splitter splitPane = new Splitter(true);
        splitPane.setFirstComponent((JComponent)this.testRunBrowserPanel);
        splitPane.setSecondComponent((JComponent)coverageContributionPanel);
        splitPane.setHonorComponentsMinimumSize(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean doVertical;
                Dimension dimension = e.getComponent().getSize();
                boolean bl = doVertical = dimension.getWidth() < dimension.getHeight();
                if (doVertical != splitPane.getOrientation()) {
                    splitPane.setOrientation(doVertical);
                }
            }
        });
        this.add((Component)splitPane, "Center");
    }

    public static TestRunExplorerToolWindow getInstance(Project project) {
        TestRunExplorerToolWindow window = (TestRunExplorerToolWindow)project.getUserData(WINDOW_PROJECT_KEY);
        if (window == null) {
            window = new TestRunExplorerToolWindow(project);
            project.putUserData(WINDOW_PROJECT_KEY, (Object)window);
        }
        return window;
    }

    @Override
    public synchronized void update(CloverDatabase db) {
        this.currentCloverDatabase = db;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                TestRunExplorerToolWindow.this.doUpdate();
            }
        });
    }

    private void setTestViewScope(TestViewScope newScope) {
        if (this.testViewScope != newScope) {
            this.testViewScope = newScope;
            this.testRunBrowserPanel.showCoverageColumns(this.calculateCoverage && this.testViewScope != TestViewScope.STATEMENT);
        }
    }

    public void setCalculateCoverage(boolean newCalculateCoverage) {
        if (this.calculateCoverage != newCalculateCoverage) {
            this.calculateCoverage = newCalculateCoverage;
            this.testRunBrowserPanel.showCoverageColumns(this.calculateCoverage && this.testViewScope != TestViewScope.STATEMENT);
        }
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        PropertyChangeEvent propertyChange;
        if (evt.hasPropertyChange("enabled")) {
            propertyChange = evt.getPropertyChange("enabled");
            boolean enabled = (Boolean)propertyChange.getNewValue();
            if (this.toolWindow != null) {
                this.toolWindow.setAvailable(enabled, null);
            }
        }
        if (evt.hasPropertyChange("testViewScope")) {
            propertyChange = evt.getPropertyChange("testViewScope");
            this.setTestViewScope((TestViewScope)((Object)propertyChange.getNewValue()));
            this.scheduleUpdate();
        }
        if (evt.hasPropertyChange("calculateTestCoverage")) {
            boolean calculate = (Boolean)evt.getPropertyChange("calculateTestCoverage").getNewValue();
            this.setCalculateCoverage(calculate);
            if (calculate) {
                this.scheduleUpdate();
            }
        }
        if (evt.hasPropertyChange("flattenPackages")) {
            this.flattenPackages = (Boolean)evt.getPropertyChange("flattenPackages").getNewValue();
            this.scheduleUpdate();
        }
        if (evt.hasPropertyChange("testCaseLayout")) {
            this.testCaseLayout = (TestCaseLayout)((Object)evt.getPropertyChange("testCaseLayout").getNewValue());
            this.scheduleUpdate();
        }
        if (evt.hasPropertyChange("alwaysCollapseTestClasses")) {
            this.testRunBrowserPanel.setAlwaysCollapseTestCases((Boolean)evt.getPropertyChange("alwaysCollapseTestClasses").getNewValue());
        }
        if (evt.hasPropertyChange("alwaysExpandTestClasses")) {
            this.testRunBrowserPanel.setAlwaysExpandTestCases((Boolean)evt.getPropertyChange("alwaysExpandTestClasses").getNewValue());
        }
    }

    @Nullable
    private CoverageDataReceptor findSelectedReceptor(@NotNull CloverDatabase cloverDatabase, TestViewScope testViewScope) {
        if (testViewScope == TestViewScope.GLOBAL) {
            return cloverDatabase.getAppOnlyModel();
        }
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (selectedTextEditor == null) {
            return null;
        }
        Document document = selectedTextEditor.getDocument();
        VirtualFile currentFile = FileDocumentManager.getInstance().getFile(document);
        if (currentFile == null) {
            return null;
        }
        String path = VfsUtil.getRootRelativeFilename(this.project, currentFile);
        FullFileInfo fileInfo = (FullFileInfo)cloverDatabase.getFullModel().findFile(path);
        if (fileInfo == null) {
            return null;
        }
        if (testViewScope == TestViewScope.FILE) {
            return fileInfo;
        }
        LogicalPosition caretPosition = selectedTextEditor.getCaretModel().getLogicalPosition();
        StatementsAggregatingVisitor sav = new StatementsAggregatingVisitor(caretPosition);
        fileInfo.visitElements(sav);
        switch (testViewScope) {
            case CLASS: {
                return sav.getMostNarrowClass();
            }
            case METHOD: {
                return sav.getMostNarrowMethod();
            }
            case STATEMENT: {
                return sav.getMostNarrowStatement();
            }
        }
        throw new IllegalStateException(testViewScope.toString());
    }

    private void saveState(CoverageDataReceptor receptor) {
        this.previousReceptor = new WeakReference<CoverageDataReceptor>(receptor == null ? NULL_MARKER : receptor);
        this.prevCoverageCalculated = this.calculateCoverage;
        this.prevFlattenPackages = this.flattenPackages;
        this.prevTestCaseLayout = this.testCaseLayout;
    }

    private boolean needsRefresh(CoverageDataReceptor receptor) {
        return this.previousReceptor == null || this.previousReceptor.get() != (receptor == null ? NULL_MARKER : receptor) || this.prevCoverageCalculated != this.calculateCoverage || this.prevFlattenPackages != this.flattenPackages || this.prevTestCaseLayout != this.testCaseLayout;
    }

    private void doUpdate() {
        CoverageDataReceptor receptor;
        CoverageDataReceptor coverageDataReceptor = receptor = this.currentCloverDatabase == null ? null : this.findSelectedReceptor(this.currentCloverDatabase, this.testViewScope);
        if (this.needsRefresh(receptor)) {
            this.saveState(receptor);
            if (receptor != null) {
                this.testRunBrowserPanel.update(this.currentCloverDatabase, receptor, this.calculateCoverage, this.flattenPackages, this.testCaseLayout);
            } else {
                this.testRunBrowserPanel.clean();
            }
        }
    }

    public synchronized void scheduleUpdate() {
        if (!this.scheduledCalculationPending) {
            this.scheduledCalculationPending = true;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TestRunExplorerToolWindow testRunExplorerToolWindow = TestRunExplorerToolWindow.this;
                    synchronized (testRunExplorerToolWindow) {
                        TestRunExplorerToolWindow.this.scheduledCalculationPending = false;
                    }
                    TestRunExplorerToolWindow.this.doUpdate();
                }
            });
        }
    }

    public void register() {
        if (this.toolWindow == null) {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.project);
            IProjectPlugin projectPlugin = ProjectPlugin.getPlugin(this.project);
            IdeaCloverConfig config = projectPlugin.getConfig();
            this.toolWindow = toolWindowManager.registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.LEFT);
            ContentManager contentManager = this.toolWindow.getContentManager();
            Content content = contentManager.getFactory().createContent((JComponent)this, TOOL_WINDOW_NAME, false);
            contentManager.addContent(content);
            this.toolWindow.setIcon(CloverIcons.TOOL_WINDOW);
            this.toolWindow.setAvailable(config.isEnabled(), null);
            projectPlugin.getCoverageManager().addCoverageListener(this);
            config.addConfigChangeListener(this);
            EventListenerInstallator.install(this.project, FileEditorManagerListener.FILE_EDITOR_MANAGER, this);
            this.setTestViewScope(config.getTestViewScope());
            this.setCalculateCoverage(config.isCalculateTestCoverage());
            this.testRunBrowserPanel.setAlwaysCollapseTestCases(config.isAlwaysCollapseTestClasses());
            this.testRunBrowserPanel.setAlwaysExpandTestCases(config.isAlwaysExpandTestClasses());
            this.flattenPackages = config.isFlattenPackages();
            this.testCaseLayout = config.getTestCaseLayout();
            SelectInCloverTarget.getInstance(this.project).addView(this.selectInCloverHandler, 1);
        }
    }

    public void unregister() {
        SelectInCloverTarget.getInstance(this.project).removeView(this.selectInCloverHandler);
        if (this.toolWindow != null) {
            IProjectPlugin projectPlugin = ProjectPlugin.getPlugin(this.project);
            projectPlugin.getCoverageManager().removeCoverageListener(this);
            projectPlugin.getConfig().removeConfigChangeListener(this);
            ToolWindowManager.getInstance((Project)this.project).unregisterToolWindow(TOOL_WINDOW_ID);
        }
    }

    public void fileOpened(FileEditorManager fileEditorManager, VirtualFile virtualFile) {
        for (FileEditor editor : fileEditorManager.getEditors(virtualFile)) {
            if (!(editor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)editor;
            textEditor.getEditor().getCaretModel().addCaretListener((CaretListener)this);
        }
    }

    public void fileClosed(FileEditorManager fileEditorManager, VirtualFile virtualFile) {
        this.scheduleUpdate();
    }

    public void selectionChanged(FileEditorManagerEvent event) {
        this.scheduleUpdate();
    }

    public void caretPositionChanged(CaretEvent event) {
        if (this.testViewScope != TestViewScope.GLOBAL && this.testViewScope != TestViewScope.FILE) {
            this.scheduleUpdate();
        }
    }

    public void caretAdded(CaretEvent caretEvent) {
    }

    public void caretRemoved(CaretEvent caretEvent) {
    }

    private class SelectInCloverHandler
    implements SelectInCloverView {
        private SelectInCloverHandler() {
        }

        private PsiMethod getMethod(PsiElement element) {
            PsiElement e;
            for (e = element; e != null && !(e instanceof PsiMethod); e = e.getParent()) {
            }
            return (PsiMethod)e;
        }

        @Override
        public boolean canSelect(SelectInContext context) {
            Object selector = context.getSelectorInFile();
            return this.findTestCase(selector) != null;
        }

        private TestCaseInfo findTestCase(Object selector) {
            PsiMethod method;
            CloverDatabase database = TestRunExplorerToolWindow.this.currentCloverDatabase;
            if (database != null && selector instanceof PsiElement && (method = this.getMethod((PsiElement)selector)) != null) {
                PsiClass clazz = method.getContainingClass();
                Set<TestCaseInfo> tests = database.getCoverageData().getTests();
                for (TestCaseInfo test : tests) {
                    if (!test.getRuntimeTypeName().equals(clazz.getQualifiedName()) || !test.getSourceMethod().getSimpleName().equals(method.getName())) continue;
                    return test;
                }
            }
            return null;
        }

        @Override
        public boolean selectIn(SelectInContext context) {
            Object selector = context.getSelectorInFile();
            TestCaseInfo testCase = this.findTestCase(selector);
            if (testCase != null) {
                Set<TestCaseInfo> tests = Collections.singleton(testCase);
                TestRunExplorerToolWindow.this.testRunBrowserPanel.update(TestRunExplorerToolWindow.this.currentCloverDatabase, tests, TestRunExplorerToolWindow.this.flattenPackages, TestRunExplorerToolWindow.this.testCaseLayout);
                TestRunExplorerToolWindow.this.toolWindow.activate(null);
                IdeaCloverConfig ideaCloverConfig = ProjectPlugin.getPlugin(TestRunExplorerToolWindow.this.project).getConfig();
                ideaCloverConfig.setTestViewScope(TestViewScope.METHOD);
                ideaCloverConfig.notifyListeners();
            }
            return testCase != null;
        }
    }

    static interface TestCaseSelectionListener {
        public void valueChanged(TestCaseInfo var1);
    }
}

