/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.idea.config.TestCaseLayout;
import com.atlassian.clover.idea.testexplorer.ContribCoverageColumnInfo;
import com.atlassian.clover.idea.testexplorer.DecoratedTestCaseInfo;
import com.atlassian.clover.idea.testexplorer.TestRunExplorerToolWindow;
import com.atlassian.clover.idea.testexplorer.TestRunExplorerTreeBuilder;
import com.atlassian.clover.idea.testexplorer.UniqueCoverageColumnInfo;
import com.atlassian.clover.idea.treetables.TreeTableModelFactory;
import com.atlassian.clover.idea.treetables.TreeTablePanel;
import com.atlassian.clover.idea.util.ui.TreeExpansionHelper;
import com.atlassian.clover.idea.util.ui.TreeSelectionHelper;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openclover.util.Lists;

public class TestRunBrowserPanel
extends TreeTablePanel {
    private final List<TestRunExplorerToolWindow.TestCaseSelectionListener> listeners = Lists.newArrayList();
    private final TestRunExplorerTreeBuilder treeBuilder;
    private final Collection<Pair<Integer, TableColumn>> coverageColumns = Lists.newArrayList();

    public TestRunBrowserPanel(Project project) {
        super(project, TreeTableModelFactory.getTestCasesTreeTableModel(null));
        this.treeBuilder = new TestRunExplorerTreeBuilder(project, this.tableModel, this.rootNode);
        this.treeTableView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                TestRunBrowserPanel.this.updateTestCaseSelectionListeners(node);
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTableView), "Center");
        this.indexCoverageColumns();
    }

    public void addTestCaseSelectionListener(TestRunExplorerToolWindow.TestCaseSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeTestCaseSelectionListener(TestRunExplorerToolWindow.TestCaseSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void updateTestCaseSelectionListeners(DefaultMutableTreeNode node) {
        Object userObject = node == null ? null : node.getUserObject();
        TestCaseInfo tci = (TestCaseInfo)(userObject instanceof TestCaseInfo ? userObject : null);
        if (tci instanceof DecoratedTestCaseInfo) {
            tci = ((DecoratedTestCaseInfo)tci).getNakedTestCaseInfo();
        }
        for (TestRunExplorerToolWindow.TestCaseSelectionListener listener : this.listeners) {
            listener.valueChanged(tci);
        }
    }

    public void update(CloverDatabase cloverDatabase, CoverageDataReceptor receptor, boolean calculateCoverage, boolean flatten, TestCaseLayout testCaseLayout) {
        boolean customExpand = !this.alwaysExpandTestCases && !this.alwaysCollapseTestCases;
        TreeSelectionHelper teh = customExpand ? new TreeExpansionHelper((JTree)this.treeTableView.getTree()) : new TreeSelectionHelper((JTree)this.treeTableView.getTree());
        this.rootNode.removeAllChildren();
        this.treeBuilder.cancelLastCalculator();
        if (cloverDatabase != null) {
            this.treeBuilder.populate(cloverDatabase, receptor, testCaseLayout, flatten, calculateCoverage);
        }
        this.tableModel.nodeStructureChanged(this.rootNode);
        if (!customExpand && this.alwaysExpandTestCases) {
            this.expandAll(true);
        }
        teh.restore((JTree)this.treeTableView.getTree());
        TreePath selection = this.treeTableView.getTree().getSelectionModel().getSelectionPath();
        if (selection == null && this.treeTableView.getRowCount() > 0) {
            selection = this.treeTableView.getTree().getPathForRow(this.treeTableView.getRowCount() - 1);
            this.treeTableView.getTree().getSelectionModel().setSelectionPath(selection);
        }
        this.updateTestCaseSelectionListeners(selection != null ? (DefaultMutableTreeNode)selection.getLastPathComponent() : null);
    }

    public void update(CloverDatabase cloverDatabase, Collection<TestCaseInfo> testCases, boolean flatten, TestCaseLayout testCaseLayout) {
        this.rootNode.removeAllChildren();
        if (cloverDatabase != null) {
            this.treeBuilder.populate(cloverDatabase, testCases, testCaseLayout, flatten);
        }
        this.tableModel.nodeStructureChanged(this.rootNode);
        this.expandAll(true);
        this.treeTableView.getTree().setSelectionRow(this.treeTableView.getRowCount() - 1);
    }

    @Override
    public void clean() {
        super.clean();
        this.updateTestCaseSelectionListeners(null);
    }

    public void setAlwaysExpandTestCases(boolean newAlwaysExpandTestCases) {
        if (this.alwaysExpandTestCases != newAlwaysExpandTestCases) {
            this.alwaysExpandTestCases = newAlwaysExpandTestCases;
            this.expansionChanged();
        }
    }

    public void setAlwaysCollapseTestCases(boolean newAlwaysCollapseTestCases) {
        if (this.alwaysCollapseTestCases != newAlwaysCollapseTestCases) {
            this.alwaysCollapseTestCases = newAlwaysCollapseTestCases;
            this.expansionChanged();
        }
    }

    private void expansionChanged() {
        if (this.alwaysCollapseTestCases != this.alwaysExpandTestCases) {
            this.expandAll(this.alwaysExpandTestCases);
        }
    }

    private void indexCoverageColumns() {
        ColumnInfo[] ci = this.tableModel.getColumnInfos();
        for (int i = 0; i < ci.length; ++i) {
            ColumnInfo columnInfo = ci[i];
            if (!(columnInfo instanceof ContribCoverageColumnInfo) && !(columnInfo instanceof UniqueCoverageColumnInfo)) continue;
            this.coverageColumns.add((Pair<Integer, TableColumn>)Pair.create((Object)i, (Object)this.treeTableView.getColumnModel().getColumn(i)));
        }
    }

    public void showCoverageColumns(boolean show) {
        TableColumnModel tableColumnModel = this.treeTableView.getColumnModel();
        for (Pair<Integer, TableColumn> tc : this.coverageColumns) {
            tableColumnModel.removeColumn((TableColumn)tc.getSecond());
            if (!show) continue;
            tableColumnModel.addColumn((TableColumn)tc.getSecond());
            tableColumnModel.moveColumn(tableColumnModel.getColumnCount() - 1, (Integer)tc.getFirst());
        }
    }
}

