/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.idea.coverage.PercentBarColors;
import com.atlassian.clover.idea.coverage.PercentBarPanel;
import java.awt.Component;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class PercentBarTableCellRenderer
extends PercentBarPanel
implements TableCellRenderer {
    private static final DefaultTableCellRenderer EMPTY_RENDERER = new DefaultTableCellRenderer();
    private static Map<PercentBarColors, PercentBarTableCellRenderer> INSTANCES = new EnumMap<PercentBarColors, PercentBarTableCellRenderer>(PercentBarColors.class);

    public PercentBarTableCellRenderer(PercentBarColors colors) {
        super(colors);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return EMPTY_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Float pc = (Float)value;
        this.setPercent(pc.floatValue());
        return this;
    }

    public static TableCellRenderer getInstance() {
        return PercentBarTableCellRenderer.getInstance(PercentBarColors.LIGHTBLUE_ON_WHITE);
    }

    public static TableCellRenderer getInstance(PercentBarColors colors) {
        PercentBarTableCellRenderer instance = INSTANCES.get((Object)colors);
        if (instance == null) {
            instance = new PercentBarTableCellRenderer(colors);
            INSTANCES.put(colors, instance);
        }
        return instance;
    }
}

