/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.testexplorer.HasCoverageInfo;
import com.atlassian.clover.idea.util.tasks.AbstractExpirableTaskDelegate;
import com.atlassian.clover.idea.util.tasks.ExpirableTaskProcessor;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.StackTraceInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratedTestCaseInfo
extends TestCaseInfo
implements HasCoverageInfo {
    @NotNull
    private final TestCaseInfo decorated;
    private float coverage = -1.0f;
    private float uniqueCoverage = -1.0f;
    private Calculator calculator;

    public DecoratedTestCaseInfo(@NotNull TestCaseInfo decorated, CoverageDataReceptor receptor, CloverDatabase currentDatabase, CoverageManager coverageManager) {
        super(null, null, null, null);
        this.decorated = decorated;
        this.calculator = new Calculator(receptor, currentDatabase, coverageManager);
    }

    private void calcValues() {
        if (this.calculator != null) {
            ExpirableTaskProcessor.getInstance().queue(this.calculator);
        }
    }

    private static CoverageDataReceptor copyReceptor(CoverageDataReceptor receptor) {
        if (receptor instanceof FullProjectInfo) {
            return ((FullProjectInfo)receptor).copy();
        }
        if (receptor instanceof FullFileInfo) {
            FullFileInfo fileInfo = (FullFileInfo)receptor;
            return fileInfo.copy((FullPackageInfo)fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
        }
        if (receptor instanceof FullClassInfo) {
            FullClassInfo classInfo = (FullClassInfo)receptor;
            return classInfo.copy((FullFileInfo)classInfo.getContainingFile(), HasMetricsFilter.ACCEPT_ALL);
        }
        if (receptor instanceof FullMethodInfo) {
            FullMethodInfo methodInfo = (FullMethodInfo)receptor;
            if (methodInfo.getContainingClass() != null) {
                return methodInfo.copy((FullClassInfo)methodInfo.getContainingClass());
            }
            if (methodInfo.getContainingMethod() != null) {
                return methodInfo.copy((FullMethodInfo)methodInfo.getContainingMethod());
            }
            return methodInfo.copy((FullFileInfo)methodInfo.getContainingFile());
        }
        return null;
    }

    public void setAsyncUpdate(Runnable asyncUpdate) {
        if (this.calculator != null) {
            this.calculator.asyncUpdate = asyncUpdate;
        }
    }

    @NotNull
    public TestCaseInfo getNakedTestCaseInfo() {
        return this.decorated;
    }

    @Override
    public float getCoverage() {
        if (this.coverage == -1.0f) {
            this.calcValues();
        }
        return this.coverage;
    }

    @Override
    public float getUniqueCoverage() {
        if (this.uniqueCoverage == -1.0f) {
            this.calcValues();
        }
        return this.uniqueCoverage;
    }

    public void setCoverage(float coverage) {
        this.coverage = coverage;
    }

    public void setUniqueCoverage(float uniqueCoverage) {
        this.uniqueCoverage = uniqueCoverage;
    }

    @Override
    public Integer getId() {
        return this.decorated.getId();
    }

    @Override
    public boolean isResolved() {
        return this.decorated.isResolved();
    }

    @Override
    public String getKey() {
        return this.decorated.getKey();
    }

    @Override
    public String getTestName() {
        return this.decorated.getTestName();
    }

    @Override
    public String getClassName() {
        return this.decorated.getClassName();
    }

    @Override
    public double getDuration() {
        return this.decorated.getDuration();
    }

    @Override
    public boolean isError() {
        return this.decorated.isError();
    }

    @Override
    public boolean isHasResult() {
        return this.decorated.isHasResult();
    }

    @Override
    public boolean isFailure() {
        return this.decorated.isFailure();
    }

    @Override
    public boolean isSuccess() {
        return this.decorated.isSuccess();
    }

    @Override
    public String getFailMessage() {
        return this.decorated.getFailMessage();
    }

    @Override
    public String getFailType() {
        return this.decorated.getFailType();
    }

    @Override
    public String getFailFullMessage() {
        return this.decorated.getFailFullMessage();
    }

    @Override
    @Nullable
    public StackTraceInfo getStackTrace() {
        return this.decorated.getStackTrace();
    }

    @Override
    @Nullable
    public FullClassInfo getRuntimeType() {
        return this.decorated.getRuntimeType();
    }

    @Override
    @Nullable
    public FullMethodInfo getSourceMethod() {
        return this.decorated.getSourceMethod();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.decorated.getQualifiedName();
    }

    @Override
    @Nullable
    public String getRuntimeTypeName() {
        return this.decorated.getRuntimeTypeName();
    }

    @Override
    @Nullable
    public String getSourceMethodName() {
        return this.decorated.getSourceMethodName();
    }

    @Override
    public long getStartTime() {
        return this.decorated.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.decorated.getEndTime();
    }

    @Override
    public void setId(Integer id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean resolve(FullProjectInfo project) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHasResult(boolean hasResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDuration(double duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setError(boolean error) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFailure(boolean failure) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFailMessage(String failMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFailType(String failType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFailFullMessage(String failFullMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStartTime(long startTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEndTime(long endTime) {
        throw new UnsupportedOperationException();
    }

    private class Calculator
    extends AbstractExpirableTaskDelegate {
        private final CoverageDataReceptor receptor;
        private final CloverDatabase cloverDatabase;
        private final CoverageManager coverageManager;
        private Runnable asyncUpdate;

        public Calculator(CoverageDataReceptor receptor, CloverDatabase cloverDatabase, CoverageManager coverageManager) {
            super("Calculating test unique coverage");
            this.receptor = receptor;
            this.cloverDatabase = cloverDatabase;
            this.coverageManager = coverageManager;
        }

        @Override
        public void run(@NotNull ProgressIndicator progressIndicator) {
            CoverageDataReceptor receptorCopy = DecoratedTestCaseInfo.copyReceptor(this.receptor);
            CoverageData coverageData = this.cloverDatabase.getCoverageData();
            BitSet testCoverage = coverageData.getHitsFor(DecoratedTestCaseInfo.this.decorated);
            BitSetCoverageProvider dataProvider = new BitSetCoverageProvider(testCoverage, coverageData);
            receptorCopy.setDataProvider(dataProvider);
            DecoratedTestCaseInfo.this.coverage = ((HasMetrics)((Object)receptorCopy)).getMetrics().getPcCoveredElements();
            CoverageData data = this.cloverDatabase.getCoverageData();
            BitSet uniqueTestCoverage = data.getUniqueHitsFor(DecoratedTestCaseInfo.this.decorated);
            BitSetCoverageProvider uniqueDataProvider = new BitSetCoverageProvider(uniqueTestCoverage, data);
            receptorCopy.setDataProvider(uniqueDataProvider);
            DecoratedTestCaseInfo.this.uniqueCoverage = ((HasMetrics)((Object)receptorCopy)).getMetrics().getPcCoveredElements();
        }

        @Override
        public void onSuccess() {
            if (this.asyncUpdate != null) {
                this.asyncUpdate.run();
            }
            DecoratedTestCaseInfo.this.calculator = null;
        }

        @Override
        public void onCancel() {
            DecoratedTestCaseInfo.this.calculator = null;
        }

        @Override
        public boolean shouldProceed() {
            return DecoratedTestCaseInfo.this.coverage == -1.0f && this.cloverDatabase == this.coverageManager.getCoverage();
        }
    }
}

