/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.coverage.CoverageListener;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.testexplorer.ContribTreeCellRenderer;
import com.atlassian.clover.idea.testexplorer.CoverageContributionTreeBuilder;
import com.atlassian.clover.idea.testexplorer.TestRunExplorerToolWindow;
import com.atlassian.clover.idea.treetables.SortableListTreeTableModelOnColumns;
import com.atlassian.clover.idea.treetables.TreeTableModelFactory;
import com.atlassian.clover.idea.util.ui.ScrollToSourceMouseAdapter;
import com.atlassian.clover.idea.util.ui.TreeExpansionHelper;
import com.atlassian.clover.idea.util.ui.TreeUtil;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.intellij.openapi.project.Project;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CoverageContributionPanel
extends JPanel
implements TestRunExplorerToolWindow.TestCaseSelectionListener,
CoverageListener,
ConfigChangeListener {
    private CloverDatabase currentDatabase;
    private boolean alwaysCollapseTestClasses;
    private boolean alwaysExpandTestClasses;
    private boolean flattenPackages;
    private final Project project;
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private final SortableListTreeTableModelOnColumns tableModel = TreeTableModelFactory.getTestCaseInfoTreeTableModel(this.rootNode);
    private final TreeTableView treeTableView = new TreeTableView((ListTreeTableModelOnColumns)this.tableModel);
    private final CoverageContributionTreeBuilder treeBuilder = new CoverageContributionTreeBuilder(this.rootNode, this.tableModel);
    private TestCaseInfo lastTestCaseInfo;
    private boolean lastFlattenPackages;

    public CoverageContributionPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.registerListeners(project);
        IdeaCloverConfig config = ProjectPlugin.getPlugin(project).getConfig();
        this.alwaysCollapseTestClasses = config.isAlwaysCollapseTestClasses();
        this.alwaysExpandTestClasses = config.isAlwaysExpandTestClasses();
        this.flattenPackages = config.isFlattenPackages();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.treeTableView.setRootVisible(false);
        this.treeTableView.setTreeCellRenderer((TreeCellRenderer)new ContribTreeCellRenderer());
        this.treeTableView.getTree().setShowsRootHandles(true);
        this.treeTableView.setSelectionMode(0);
        this.treeTableView.setAutoResizeMode(4);
        this.treeTableView.setAutoscrolls(true);
        this.treeTableView.setMinimumSize(this.treeTableView.getPreferredSize());
        this.treeTableView.addMouseListener((MouseListener)ScrollToSourceMouseAdapter.getInstance(this.project));
        this.treeTableView.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = CoverageContributionPanel.this.treeTableView.getTableHeader().getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                int modelColumn = columnModel.getColumn(column).getModelIndex();
                CoverageContributionPanel.this.tableModel.sortByColumn(modelColumn);
                CoverageContributionPanel.this.sortNodes();
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTableView), "Center");
    }

    private void sortNodes() {
        boolean customExpand = !this.alwaysExpandTestClasses && !this.alwaysCollapseTestClasses;
        TreeExpansionHelper teh = customExpand ? new TreeExpansionHelper((JTree)this.treeTableView.getTree()) : null;
        TreeUtil.sortNodes(this.rootNode, this.tableModel);
        this.tableModel.reload();
        if (customExpand) {
            teh.restore((JTree)this.treeTableView.getTree());
        } else if (this.alwaysExpandTestClasses) {
            this.expandOrCollapseAll();
        }
    }

    private void registerListeners(Project project) {
        IProjectPlugin projectPlugin = ProjectPlugin.getPlugin(project);
        CoverageManager coverageManager = projectPlugin.getCoverageManager();
        this.currentDatabase = coverageManager.getCoverage();
        coverageManager.addCoverageListener(this);
        projectPlugin.getConfig().addConfigChangeListener(this);
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        PropertyChangeEvent propertyChange;
        if (evt.hasPropertyChange("alwaysCollapseTestClasses")) {
            propertyChange = evt.getPropertyChange("alwaysCollapseTestClasses");
            this.alwaysCollapseTestClasses = (Boolean)propertyChange.getNewValue();
            this.expandOrCollapseAll();
        }
        if (evt.hasPropertyChange("alwaysExpandTestClasses")) {
            propertyChange = evt.getPropertyChange("alwaysExpandTestClasses");
            this.alwaysExpandTestClasses = (Boolean)propertyChange.getNewValue();
            this.expandOrCollapseAll();
        }
        if (evt.hasPropertyChange("flattenPackages")) {
            propertyChange = evt.getPropertyChange("flattenPackages");
            this.flattenPackages = (Boolean)propertyChange.getNewValue();
            this.valueChanged(this.lastTestCaseInfo);
        }
    }

    private void expandOrCollapseAll() {
        if (this.alwaysCollapseTestClasses != this.alwaysExpandTestClasses) {
            TreeTableTree treeTableTree = this.treeTableView.getTree();
            Enumeration<TreeNode> children = this.rootNode.postorderEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (this.rootNode == child || child.isLeaf()) continue;
                TreePath path = new TreePath(child.getPath());
                if (this.alwaysExpandTestClasses) {
                    treeTableTree.expandPath(path);
                    continue;
                }
                treeTableTree.collapsePath(path);
            }
        }
    }

    @Override
    public void valueChanged(TestCaseInfo testCaseInfo) {
        if (this.lastTestCaseInfo == testCaseInfo && this.lastFlattenPackages == this.flattenPackages) {
            return;
        }
        this.lastTestCaseInfo = testCaseInfo;
        this.lastFlattenPackages = this.flattenPackages;
        boolean customExpand = !this.alwaysExpandTestClasses && !this.alwaysCollapseTestClasses;
        TreeExpansionHelper teh = customExpand ? new TreeExpansionHelper((JTree)this.treeTableView.getTree()) : null;
        this.rootNode.removeAllChildren();
        if (testCaseInfo != null) {
            this.treeBuilder.processClassesFor(this.currentDatabase, testCaseInfo, this.flattenPackages);
        }
        this.tableModel.reload();
        if (customExpand) {
            teh.restore((JTree)this.treeTableView.getTree());
        } else if (this.alwaysExpandTestClasses) {
            this.expandOrCollapseAll();
        }
    }

    @Override
    public void update(CloverDatabase db) {
        this.currentDatabase = db;
    }
}

