/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.jfc;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.idea.treetables.CellRendererUtil;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class HasMetricsTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public DefaultTreeCellRenderer getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        HasMetrics hasMetrics = value instanceof DefaultMutableTreeNode ? (HasMetrics)((DefaultMutableTreeNode)value).getUserObject() : (HasMetrics)value;
        if (hasMetrics instanceof FullProjectInfo) {
            this.setIcon(CloverIcons.IDEA_PROJECT);
            this.setText(hasMetrics.getName());
        } else if (hasMetrics instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)hasMetrics;
            this.setIcon(CellRendererUtil.getIconForMethodInfo(methodInfo));
            this.setText(hasMetrics.getName());
        } else if (hasMetrics instanceof BaseClassInfo) {
            BaseClassInfo classInfo = (BaseClassInfo)hasMetrics;
            this.setIcon(CellRendererUtil.getIconForClassInfo(classInfo));
            this.setText(hasMetrics.getName());
        } else if (hasMetrics != null) {
            this.setIcon(leaf ? null : (expanded ? CloverIcons.PACKAGE_OPEN : CloverIcons.PACKAGE_CLOSED));
            String mangledName = new StringBuilder(hasMetrics.getName()).append('\u202e').reverse().toString();
            this.setText(mangledName);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        int maxWidth = g.getClipBounds().width;
        if (maxWidth < this.getWidth()) {
            this.setSize(maxWidth, this.getHeight());
        }
        super.paint(g);
    }
}

