/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.cloud;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.idea.HasMetricsListener;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.actions.Constants;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.coverage.BaseCoverageNodeViewer;
import com.atlassian.clover.idea.coverage.CoverageListener;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.coverage.ModelUtil;
import com.atlassian.clover.idea.report.cloud.AggregatingFilter;
import com.atlassian.clover.idea.report.cloud.CloudReportView;
import com.atlassian.clover.idea.report.cloud.CloudVirtualFile;
import com.atlassian.clover.idea.report.cloud.IdeaEditorLinkingHtmlRenderingSupport;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.reporters.CloudGenerator;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CloudEditorController
implements CoverageListener,
HasMetricsListener,
ConfigChangeListener,
DataProvider {
    private final CoverageManager coverageManager;
    private final CloudVirtualFile cloudVirtualFile;
    private final CloudReportView cloudView;
    private final IdeaCloverConfig config;
    private boolean includeSubpkgs;
    private ModelScope modelScope;
    private WeakReference<HasMetrics> lastSelectedElement;
    private WeakReference<CloverDatabase> lastSelectedDatabase;

    public CloudEditorController(Project project, CloudVirtualFile cloudVirtualFile, CloudReportView cloudView) {
        this.cloudView = cloudView;
        this.cloudVirtualFile = cloudVirtualFile;
        this.coverageManager = cloudVirtualFile.getCoverageManager();
        this.config = ProjectPlugin.getPlugin(project).getConfig();
        this.includeSubpkgs = this.config.isCloudReportIncludeSubpkgs();
        this.modelScope = this.config.getModelScope();
        this.config.addConfigChangeListener(this);
        this.coverageManager.addCoverageListener(this);
        cloudVirtualFile.addHasMetricsListener(this);
    }

    private String generateRiskHtml(List<? extends ClassInfo> classes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IdeaEditorLinkingHtmlRenderingSupport htmlRenderingSupport = new IdeaEditorLinkingHtmlRenderingSupport();
        CloudGenerator cloudGenerator = new CloudGenerator("cloud-idea.vm", htmlRenderingSupport, outputStream);
        try {
            cloudGenerator.createReport(classes, new ClassInfoStatsCalculator.AvgMethodComplexityCalculator(), new ClassInfoStatsCalculator.PcCoveredElementsCalculator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.toString();
    }

    private String generateWinHtml(List<? extends ClassInfo> classes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IdeaEditorLinkingHtmlRenderingSupport htmlRenderingSupport = new IdeaEditorLinkingHtmlRenderingSupport();
        CloudGenerator cloudGenerator = new CloudGenerator("cloud-idea.vm", htmlRenderingSupport, outputStream);
        try {
            cloudGenerator.createReport(classes, new ClassInfoStatsCalculator.ElementCountCalculator(), new ClassInfoStatsCalculator.CoveredElementsCalculator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.toString();
    }

    private void update() {
        this.update(this.coverageManager.getCoverage(), this.cloudVirtualFile.getSelectedElement());
    }

    @Override
    public void update(CloverDatabase db) {
        this.update(db, this.cloudVirtualFile.getSelectedElement());
    }

    @Override
    public void valueChanged(HasMetrics hasMetrics) {
        this.update(this.coverageManager.getCoverage(), hasMetrics);
    }

    private void update(final CloverDatabase db, final HasMetrics selectedElement) {
        this.cacheElement(db, selectedElement);
        if (db == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloudEditorController.this.cloudView.clean();
                }
            });
            return;
        }
        final String packagePrefix = this.packagePrefix(selectedElement);
        AggregatingFilter aggregate = new AggregatingFilter(packagePrefix, selectedElement == null || this.includeSubpkgs);
        final FullProjectInfo projectInfo = ModelUtil.getModel(db, this.modelScope);
        List<? extends BaseClassInfo> allClasses = projectInfo.getClasses(aggregate);
        final String riskContent = this.generateRiskHtml(allClasses);
        final String winsContent = this.generateWinHtml(allClasses);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudEditorController.this.setPackagePrefixInfo(packagePrefix);
                CloudEditorController.this.cloudView.setRisksHtml(riskContent);
                CloudEditorController.this.cloudView.setWinsHtml(winsContent);
                HasMetrics element = selectedElement != null ? selectedElement : projectInfo;
                CloudEditorController.this.cloudView.setSummaryNode(element, new BaseCoverageNodeViewer.TestPassInfo(db.getFullModel().getMetrics()));
            }
        });
    }

    private void setPackagePrefixInfo(String packagePrefix) {
        if (packagePrefix == null) {
            this.cloudView.setSummaryIcon(CloverIcons.PROJECT);
            this.cloudView.setSummaryText("Entire project");
        } else {
            this.cloudView.setSummaryIcon(CloverIcons.PACKAGE_CLOSED);
            this.cloudView.setSummaryText("Package " + packagePrefix);
        }
    }

    void dispose() {
        this.coverageManager.removeCoverageListener(this);
        this.cloudVirtualFile.removeHasMetricsListener(this);
        this.config.removeConfigChangeListener(this);
    }

    @Nullable
    private String packagePrefix(HasMetrics selectedElement) {
        if (selectedElement instanceof PackageInfo) {
            return selectedElement.getName();
        }
        if (selectedElement instanceof PackageFragment) {
            return ((PackageFragment)selectedElement).getQualifiedName();
        }
        return null;
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("cloudReportIncludeSubpkgs")) {
            this.includeSubpkgs = (Boolean)evt.getPropertyChange("cloudReportIncludeSubpkgs").getNewValue();
            this.update();
        }
        if (evt.hasPropertyChange("modelScope")) {
            this.modelScope = (ModelScope)((Object)evt.getPropertyChange("modelScope").getNewValue());
            this.update();
        }
    }

    private void cacheElement(CloverDatabase db, HasMetrics element) {
        if (db == null) {
            this.lastSelectedDatabase = null;
            this.lastSelectedElement = null;
        } else if (element != null) {
            this.lastSelectedDatabase = new WeakReference<CloverDatabase>(db);
            this.lastSelectedElement = new WeakReference<HasMetrics>(element);
        }
    }

    private HasMetrics getCachedElement(CloverDatabase currentDb) {
        return this.lastSelectedDatabase != null && this.lastSelectedDatabase.get() == currentDb && this.lastSelectedElement != null ? (HasMetrics)this.lastSelectedElement.get() : null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return Constants.SELECTED_HAS_METRICS.getName().equals(dataId) ? this.getCachedElement(this.coverageManager.getCoverage()) : null;
    }
}

