/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.cloud;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.report.cloud.MinMaxIntPair;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;

class AggregatingFilter
implements HasMetricsFilter {
    final MinMaxIntPair complexity = new MinMaxIntPair();
    final MinMaxIntPair elements = new MinMaxIntPair();
    final MinMaxIntPair uncovered = new MinMaxIntPair();
    float maxAvgComplexity;
    float minAvgComplexity = Float.MAX_VALUE;
    final String packagePrefix;
    final int packagePrefixLen;
    final boolean includeSubpkgs;

    public AggregatingFilter(String packagePrefix, boolean includeSubpkgs) {
        this.includeSubpkgs = includeSubpkgs;
        this.packagePrefix = packagePrefix == null || packagePrefix.length() == 0 || "default-pkg".equals(packagePrefix) ? null : packagePrefix + ".";
        this.packagePrefixLen = this.packagePrefix == null ? 0 : this.packagePrefix.length();
    }

    @Override
    public boolean accept(HasMetrics hm) {
        String qualifiedName = ((ClassInfo)hm).getQualifiedName();
        if (this.packagePrefix != null && !qualifiedName.startsWith(this.packagePrefix)) {
            return false;
        }
        if (!this.includeSubpkgs && qualifiedName.indexOf(46, this.packagePrefixLen) != -1) {
            return false;
        }
        ClassMetrics metrics = (ClassMetrics)hm.getMetrics();
        int complexity = metrics.getComplexity();
        this.complexity.update(complexity);
        int numMethods = metrics.getNumMethods();
        if (numMethods > 0) {
            float avgComplexity = (float)complexity / (float)numMethods;
            if (avgComplexity > this.maxAvgComplexity) {
                this.maxAvgComplexity = avgComplexity;
            }
            if (avgComplexity < this.minAvgComplexity) {
                this.minAvgComplexity = avgComplexity;
            }
        }
        this.elements.update(metrics.getNumElements());
        this.uncovered.update(metrics.getNumUncoveredElements());
        return true;
    }
}

