/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.report.WizardConfig;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.ShowLambdaFunctions;

public class WizardToCloverReportConfigConverter {
    public static CloverReportConfig convert(WizardConfig wizardConfig, String defaultContextSpec) {
        Current reportConfig;
        switch (wizardConfig.getType()) {
            case 1: {
                WizardConfig.HtmlReport htmlConfig = wizardConfig.getHtmlConfig();
                reportConfig = new Current(Current.DEFAULT_HTML);
                reportConfig.setFormat(Format.DEFAULT_HTML);
                reportConfig.setMainFileName("index.html");
                reportConfig.setOutFile(htmlConfig.getDir());
                reportConfig.setTitle(htmlConfig.getReportTitle());
                reportConfig.getFormat().setSrcLevel(htmlConfig.isIncludeSource());
                reportConfig.setIncludeFailedTestCoverage(htmlConfig.isIncludeFailedCoverage());
                reportConfig.setShowLambdaFunctions(htmlConfig.getShowLambda() != ShowLambdaFunctions.NONE);
                reportConfig.setShowInnerFunctions(htmlConfig.getShowLambda() == ShowLambdaFunctions.FIELDS_AND_INLINE);
                break;
            }
            case 2: {
                WizardConfig.PdfReport pdfConfig = wizardConfig.getPdfConfig();
                reportConfig = new Current(Current.DEFAULT_PDF);
                reportConfig.setFormat(Format.DEFAULT_PDF);
                reportConfig.setOutFile(pdfConfig.getFile());
                reportConfig.setTitle(pdfConfig.getReportTitle());
                break;
            }
            case 3: {
                WizardConfig.XmlReport xmlConfig = wizardConfig.getXmlConfig();
                reportConfig = new Current(Current.DEFAULT_XML);
                reportConfig.setFormat(Format.DEFAULT_XML);
                reportConfig.setOutFile(xmlConfig.getFile());
                reportConfig.setTitle(xmlConfig.getReportTitle());
                reportConfig.getFormat().setSrcLevel(xmlConfig.isIncludeLineInfo());
                reportConfig.setShowLambdaFunctions(xmlConfig.getShowLambda() != ShowLambdaFunctions.NONE);
                reportConfig.setShowInnerFunctions(xmlConfig.getShowLambda() == ShowLambdaFunctions.FIELDS_AND_INLINE);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid report type: " + wizardConfig.getType());
            }
        }
        reportConfig.setAlwaysReport(true);
        String contextSpec = wizardConfig.getContextSpec();
        if (wizardConfig.isUseCurrentFilterSettings()) {
            reportConfig.getFormat().setFilter(defaultContextSpec);
        } else if (contextSpec != null) {
            reportConfig.getFormat().setFilter(contextSpec);
        } else {
            reportConfig.getFormat().setFilter("");
        }
        return reportConfig;
    }
}

