/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.idea.IDEContext;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.report.ConfigureFilterUI;
import com.atlassian.clover.idea.report.ConfigureHtmlUI;
import com.atlassian.clover.idea.report.ConfigurePdfUI;
import com.atlassian.clover.idea.report.ConfigureXmlUI;
import com.atlassian.clover.idea.report.ReportWizardDialog;
import com.atlassian.clover.idea.report.ReportWizardPage;
import com.atlassian.clover.idea.report.ReportWizardWorkspaceSettings;
import com.atlassian.clover.idea.report.SelectReportUI;
import com.atlassian.clover.idea.report.WizardConfig;
import com.atlassian.clover.idea.report.WizardToCloverReportConfigConverter;
import com.atlassian.clover.idea.util.ui.MessageDialogs;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.CloverReporter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.Stack;
import javax.swing.Icon;

public class ReportWizard {
    private static final Logger LOG = Logger.getInstance(ReportWizard.class.getName());
    public static final int FINISHED_EXIT_CODE = 0;
    public static final int CANCELLED_EXIT_CODE = 1;
    private final Stack<ReportWizardPage> previousPageStack = new Stack();
    private final String defaultContextSpec;
    private WizardConfig wizardConfig;
    private ReportWizardDialog dialog;
    private static final MessageFormat HTML_EXISTS_MESSAGE = new MessageFormat("It appears that a report already exists in {0}.\nDo you want to overwrite it?");
    private static final MessageFormat FILE_EXISTS_MESSAGE = new MessageFormat("A report already exists at {0}.\nDo you want to overwrite it?");

    public ReportWizard(IDEContext context) {
        this.defaultContextSpec = context.getContextFilterSpec();
        this.dialog = new ReportWizardDialog(this);
        this.wizardConfig = new WizardConfig(context);
        if (this.isHtmlAvailable()) {
            this.wizardConfig.setType(1);
        } else if (this.isPdfAvailable()) {
            this.wizardConfig.setType(2);
        } else if (this.isXmlAvailable()) {
            this.wizardConfig.setType(3);
        }
        SelectReportUI firstPage = new SelectReportUI(this);
        Icon[] fileTypes = context.getFileTypes();
        if (fileTypes != null && fileTypes.length == 3) {
            firstPage.setHtmlFileTypeIcon(fileTypes[0]);
            firstPage.setPdfFileTypeIcon(fileTypes[1]);
            firstPage.setXmlFileTypeIcon(fileTypes[2]);
        }
        firstPage.readConfig(this.wizardConfig);
        this.dialog.setCurrentPage(firstPage);
        this.refreshState();
    }

    public Window getDialogWindow() {
        return this.dialog.getOwner();
    }

    public CloverReportConfig getReportConfiguration() {
        CloverReportConfig reportConfig = WizardToCloverReportConfigConverter.convert(this.wizardConfig, this.defaultContextSpec);
        reportConfig.getOutFile().getParentFile().mkdirs();
        return reportConfig;
    }

    private void refreshState() {
        this.refreshState(this.hasNext());
    }

    void refreshState(boolean nextEnabled) {
        this.dialog.getPreviousAction().setEnabled(this.previousPageStack.size() > 0);
        this.dialog.getNextAction().setEnabled(nextEnabled);
        this.dialog.getFinishAction().setEnabled(this.canFinish());
    }

    private boolean hasNext() {
        ReportWizardPage currentPage = this.dialog.getCurrentPage();
        if (currentPage instanceof ConfigureFilterUI) {
            return false;
        }
        if (currentPage instanceof ConfigureHtmlUI || currentPage instanceof ConfigurePdfUI || currentPage instanceof ConfigureXmlUI) {
            return !this.wizardConfig.isUseCurrentFilterSettings();
        }
        return true;
    }

    private boolean canFinish() {
        return !(this.dialog.getCurrentPage() instanceof SelectReportUI);
    }

    protected boolean isXmlAvailable() {
        return true;
    }

    protected boolean isHtmlAvailable() {
        return true;
    }

    protected boolean isPdfAvailable() {
        return true;
    }

    protected void doNext() {
        ReportWizardPage nextPage;
        block12: {
            ReportWizardPage currentPage;
            block11: {
                currentPage = this.dialog.getCurrentPage();
                String validationErrorMessage = currentPage.validateSettings();
                if (validationErrorMessage != null) {
                    MessageDialogs.showErrorMessage(null, validationErrorMessage, "Validation Error.");
                    return;
                }
                currentPage.writeConfig(this.wizardConfig);
                this.previousPageStack.push(currentPage);
                if (!(currentPage instanceof SelectReportUI)) break block11;
                switch (this.wizardConfig.getType()) {
                    case 1: {
                        nextPage = new ConfigureHtmlUI(this);
                        break block12;
                    }
                    case 2: {
                        nextPage = new ConfigurePdfUI(this);
                        break block12;
                    }
                    case 3: {
                        nextPage = new ConfigureXmlUI(this);
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Invalid config type: " + this.wizardConfig.getType());
                    }
                }
            }
            if (!(currentPage instanceof ConfigureFilterUI)) {
                nextPage = new ConfigureFilterUI(this);
            } else {
                throw new IllegalStateException("Invalid wizard state: currentPage is " + currentPage.getClass());
            }
        }
        if (nextPage instanceof ConfigureFilterUI) {
            if (this.wizardConfig.isUseCurrentFilterSettings()) {
                this.wizardConfig.setContextSpec(this.defaultContextSpec);
            } else {
                this.wizardConfig.setContextSpec("");
            }
        }
        nextPage.readConfig(this.wizardConfig);
        nextPage.validate();
        this.dialog.setCurrentPage(nextPage);
        this.refreshState();
    }

    protected void doPrevious() {
        this.dialog.getCurrentPage().writeConfig(this.wizardConfig);
        ReportWizardPage previousPage = this.previousPageStack.pop();
        previousPage.readConfig(this.wizardConfig);
        this.dialog.setCurrentPage(previousPage);
        this.refreshState();
    }

    protected void doFinish() {
        String existsMessage;
        File reportFile;
        ReportWizardPage currentPage = this.dialog.getCurrentPage();
        currentPage.writeConfig(this.wizardConfig);
        ReportWizardWorkspaceSettings.getInstance().setIncludeSources(this.wizardConfig.getHtmlConfig().isIncludeSource());
        ReportWizardWorkspaceSettings.getInstance().setIncludeFailedCoverage(this.wizardConfig.getHtmlConfig().isIncludeFailedCoverage());
        ReportWizardWorkspaceSettings.getInstance().setShowLambda(this.wizardConfig.getHtmlConfig().getShowLambda());
        switch (this.wizardConfig.getType()) {
            case 1: {
                File htmlDir = this.wizardConfig.getHtmlConfig().getDir();
                reportFile = new File(htmlDir, "index.html");
                existsMessage = HTML_EXISTS_MESSAGE.format(new String[]{htmlDir.getAbsolutePath()});
                break;
            }
            case 2: {
                reportFile = this.wizardConfig.getPdfConfig().getFile();
                existsMessage = FILE_EXISTS_MESSAGE.format(new String[]{reportFile.getAbsolutePath()});
                break;
            }
            case 3: {
                reportFile = this.wizardConfig.getXmlConfig().getFile();
                existsMessage = FILE_EXISTS_MESSAGE.format(new String[]{reportFile.getAbsolutePath()});
                break;
            }
            default: {
                throw new IllegalStateException("Invalid config type: " + this.wizardConfig.getType());
            }
        }
        if (!reportFile.exists() || 0 == MessageDialogs.showYesNoDialog(this.dialog.getOwner(), existsMessage, "Overwrite?")) {
            this.dialog.close(0);
        }
    }

    public void show() {
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public int getExitCode() {
        return this.dialog.getExitCode();
    }

    public void doCancel() {
        this.dialog.close(1);
    }

    public static void showAndProcess(Project project, IDEContext context) {
        IdeaCloverConfig config = ProjectPlugin.getPlugin(project).getConfig();
        String initString = config.getInitString();
        ReportWizard wizard = new ReportWizard(context);
        wizard.show();
        if (0 != wizard.getExitCode()) {
            return;
        }
        CloverReportConfig reportConfig = wizard.getReportConfiguration();
        reportConfig.setInitString(initString);
        LOG.info("Generating report: " + reportConfig);
        ReportWizard.generateReport(project, reportConfig);
    }

    private static void generateReport(Project project, final CloverReportConfig reportConfig) {
        String title = "Generating " + (Object)((Object)reportConfig.getFormat().getType()) + " Clover report";
        final String description = title + " '" + reportConfig.getTitle() + "' to " + reportConfig.getOutFile();
        new Task.Backgroundable(project, title, false){
            private CloverException reportGenerationException;

            public void run(ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                indicator.setText(description);
                try {
                    CloverReporter.buildReporter(reportConfig).execute();
                }
                catch (CloverException e) {
                    this.reportGenerationException = e;
                }
            }

            public void onSuccess() {
                if (this.reportGenerationException == null) {
                    MessageDialogs.showInfoMessage(null, "Your Clover report has been generated and written to " + reportConfig.getOutFile().getAbsolutePath(), "Generation confirmation.");
                } else {
                    LOG.info(this.reportGenerationException);
                    MessageDialogs.showErrorMessage(null, "The following error has occured while generating the Clover report:\n" + this.reportGenerationException.getMessage(), "Error generating report.");
                }
            }
        }.queue();
    }
}

