/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.projectview;

import com.atlassian.clover.idea.CloverModuleComponent;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.projectview.PresentationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;

public class ProjectViewModuleNodeWrapper
extends ProjectViewModuleNode {
    public ProjectViewModuleNodeWrapper(ProjectViewModuleNode orig) {
        super(orig.getProject(), (Module)orig.getValue(), orig.getSettings());
    }

    public void update(PresentationData presentation) {
        CloverModuleComponent component;
        super.update(presentation);
        IProjectPlugin plugin = ProjectPlugin.getPlugin(this.getProject());
        if (plugin != null && plugin.getFeatureManager().isFeatureEnabled("clover-icondecoration") && (component = CloverModuleComponent.getInstance((Module)this.getValue())) != null) {
            boolean excluded = component.getConfig().isExcluded();
            PresentationUtil.overlayPresentation(presentation, !excluded);
        }
    }

    static boolean canAnnotate(AbstractTreeNode abstractNode) {
        if (!(abstractNode instanceof ProjectViewModuleNode)) {
            return false;
        }
        AbstractModuleNode node = (AbstractModuleNode)abstractNode;
        CloverModuleComponent component = CloverModuleComponent.getInstance((Module)node.getValue());
        return component != null;
    }
}

