/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.projectview;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.actions.excludes.ExclusionUtil;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import javax.swing.Icon;

public class PresentationUtil {
    private PresentationUtil() {
    }

    public static void overlayPresentation(PresentationData presentation, boolean enabled) {
        Icon baseClosedIcon;
        Icon overlay = enabled ? CloverIcons.CLOVER_ENABLED_OVL : CloverIcons.CLOVER_DISABLED_OVL;
        Icon baseOpenIcon = presentation.getIcon(true);
        if (baseOpenIcon != null) {
            LayeredIcon openIcon = new LayeredIcon(2);
            openIcon.setIcon(baseOpenIcon, 0);
            openIcon.setIcon(overlay, 1, 0, baseOpenIcon.getIconHeight() - overlay.getIconHeight());
            presentation.setOpenIcon((Icon)openIcon);
        }
        if ((baseClosedIcon = presentation.getIcon(false)) != null) {
            LayeredIcon closedIcon = new LayeredIcon(2);
            closedIcon.setIcon(baseClosedIcon, 0);
            closedIcon.setIcon(overlay, 1, 0, baseClosedIcon.getIconHeight() - overlay.getIconHeight());
            presentation.setClosedIcon((Icon)closedIcon);
        }
    }

    public static void overlayPackagePresentation(PresentationData presentation, PsiElement element) {
        IProjectPlugin plugin = ProjectPlugin.getPlugin(element.getProject());
        if (plugin != null) {
            IdeaCloverConfig config = plugin.getConfig();
            String includes = config.getIncludes();
            String excludes = config.getExcludes();
            String pattern = ExclusionUtil.getPattern(element);
            String recursivePattern = ExclusionUtil.getRecursivePattern(element);
            if (ExclusionUtil.isExplicitlyIncluded(includes, pattern) || ExclusionUtil.isExplicitlyIncluded(includes, recursivePattern)) {
                PresentationUtil.overlayPresentation(presentation, true);
            } else if (ExclusionUtil.isExplicitlyIncluded(excludes, pattern) || ExclusionUtil.isExplicitlyIncluded(excludes, recursivePattern)) {
                PresentationUtil.overlayPresentation(presentation, false);
            }
        }
    }
}

