/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.projectview;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.InclusionDetector;
import com.atlassian.clover.idea.build.ProjectInclusionDetector;
import com.atlassian.clover.idea.projectview.PresentationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

class ClassTreeNodeWrapper
extends ClassTreeNode {
    ClassTreeNodeWrapper(ClassTreeNode orig) {
        super(orig.getProject(), orig.getPsiClass(), orig.getSettings());
    }

    public void update(PresentationData presentation) {
        super.update(presentation);
        if (this.getValue() == null) {
            return;
        }
        PsiFile containingFile = ((PsiClass)this.getValue()).getContainingFile();
        if (containingFile == null) {
            return;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        IProjectPlugin plugin = ProjectPlugin.getPlugin(this.getProject());
        if (virtualFile != null && plugin != null && plugin.getFeatureManager().isFeatureEnabled("clover-icondecoration")) {
            InclusionDetector detector = ProjectInclusionDetector.processFile(this.getProject(), virtualFile);
            PresentationUtil.overlayPresentation(presentation, detector.isIncluded());
        }
    }

    static boolean canAnnotate(AbstractTreeNode abstractNode) {
        if (!(abstractNode instanceof ClassTreeNode)) {
            return false;
        }
        ClassTreeNode node = (ClassTreeNode)abstractNode;
        PsiClass psiClass = node.getPsiClass();
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return false;
        }
        return ModuleUtil.findModuleForPsiElement((PsiElement)psiClass) != null;
    }
}

