/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit.config;

import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.junit.config.OptimizedConfigurationSettings;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class OptimizedConfigurationSettingsPanel
extends JPanel {
    private final JCheckBox discardSnapshot = new JCheckBox("Discard snapshot every ");
    private final JFormattedTextField discardInterval = new JFormattedTextField();
    private final JCheckBox minimize = new JCheckBox("Minimize tests");
    private final JRadioButton noReorder = new JRadioButton("Do not reorder");
    private final JRadioButton failfast = new JRadioButton("Failing tests first");
    private final JRadioButton random = new JRadioButton("Random order");

    public OptimizedConfigurationSettingsPanel() {
        this.setLayout(new GridBagLayout());
        HorizontalBox discardPanel = new HorizontalBox();
        discardPanel.add(this.discardSnapshot);
        discardPanel.add(this.discardInterval);
        discardPanel.add(new JLabel("compiles"));
        this.add((Component)discardPanel, new GBC(0, 0).setWeight(1.0, 0.0).setFill(1));
        this.add((Component)this.minimize, new GBC(0, -1).setWeight(1.0, 0.0).setFill(1));
        VerticalBox reorderPanel = new VerticalBox();
        reorderPanel.setBorder((Border)BorderFactory.createTitledBorder("Test reordering"));
        reorderPanel.add((Component)this.noReorder);
        reorderPanel.add((Component)this.failfast);
        reorderPanel.add((Component)this.random);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.noReorder);
        bg.add(this.failfast);
        bg.add(this.random);
        this.add((Component)reorderPanel, new GBC(0, -1).setWeight(1.0, 0.0).setFill(1));
        this.add((Component)new JPanel(), new GBC(0, -1).setWeight(1.0, 1.0));
        this.discardSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptimizedConfigurationSettingsPanel.this.discardInterval.setEnabled(OptimizedConfigurationSettingsPanel.this.discardSnapshot.isSelected());
            }
        });
        this.discardInterval.setValue(0);
    }

    public void resetEditorFrom(OptimizedConfigurationSettings settings) {
        this.discardSnapshot.setSelected(settings.isDiscardSnapshots());
        this.discardInterval.setValue(settings.getCompilesBeforeStaleSnapshot());
        this.discardInterval.setEnabled(settings.isDiscardSnapshots());
        this.minimize.setSelected(settings.isMinimize());
        OptimizationOptions.TestSortOrder reordering = settings.getReorder();
        this.noReorder.setSelected(OptimizationOptions.TestSortOrder.NONE == reordering);
        this.failfast.setSelected(OptimizationOptions.TestSortOrder.FAILFAST == reordering);
        this.random.setSelected(OptimizationOptions.TestSortOrder.RANDOM == reordering);
    }

    public void applyEditorTo(OptimizedConfigurationSettings settings) {
        settings.setDiscardSnapshots(this.discardSnapshot.isSelected());
        settings.setMinimize(this.minimize.isSelected());
        settings.setCompilesBeforeStaleSnapshot((Integer)this.discardInterval.getValue());
        OptimizationOptions.TestSortOrder reordering = this.noReorder.isSelected() ? OptimizationOptions.TestSortOrder.NONE : (this.random.isSelected() ? OptimizationOptions.TestSortOrder.RANDOM : OptimizationOptions.TestSortOrder.FAILFAST);
        settings.setReorder(reordering);
    }
}

