/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage.monitor;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.coverage.monitor.AbstractCoverageMonitor;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.intellij.openapi.application.ApplicationManager;
import java.beans.PropertyChangeEvent;

public class ThreadedDatabaseMonitor
extends AbstractCoverageMonitor
implements FeatureListener,
ConfigChangeListener {
    private final Logger LOG = Logger.getInstance(ThreadedDatabaseMonitor.class.getName());
    private final Object LOCK = new Object();
    private boolean running = false;
    private boolean cleanup = false;
    private long interval = 2000L;

    public ThreadedDatabaseMonitor() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ThreadedDatabaseMonitor.this.cleanup) {
                    Object object = ThreadedDatabaseMonitor.this.LOCK;
                    synchronized (object) {
                        while (!ThreadedDatabaseMonitor.this.running && !ThreadedDatabaseMonitor.this.cleanup) {
                            try {
                                ThreadedDatabaseMonitor.this.LOCK.wait();
                            }
                            catch (InterruptedException e) {
                                ThreadedDatabaseMonitor.this.LOG.debug("ThreadedDatabaseMonitor LOCK.wait was interrupted");
                            }
                        }
                    }
                    if (ThreadedDatabaseMonitor.this.cleanup) break;
                    if (!ThreadedDatabaseMonitor.this.running) continue;
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ThreadedDatabaseMonitor.this.LOG.verbose("ThreadedDatabaseMonitor checking canLoadCoverageData.");
                            if (ThreadedDatabaseMonitor.this.coverageManager.canLoadCoverageData()) {
                                ThreadedDatabaseMonitor.this.LOG.verbose("-> Can load");
                                ThreadedDatabaseMonitor.this.coverageManager.loadCoverageData(false);
                            }
                        }
                    });
                    try {
                        Thread.sleep(ThreadedDatabaseMonitor.this.interval);
                    }
                    catch (Exception e) {
                        ThreadedDatabaseMonitor.this.LOG.debug("ThreadedDatabaseMonitor thread sleep was interrupted");
                    }
                }
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    public void setMonitorInterval(long l) {
        this.interval = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.LOG.verbose("start()");
        if (this.coverageManager == null) {
            throw new IllegalStateException("Can not start start threaded database monitor without first providing a coverage manager to monitor");
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.running = true;
            this.LOCK.notify();
        }
    }

    @Override
    public void stop() {
        this.LOG.verbose("stop()");
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.LOG.verbose("cleanup()");
        this.cleanup = true;
        if (!this.running) {
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
            }
        }
    }

    @Override
    public void featureStateChanged(FeatureEvent evt) {
        if (evt.isEnabled()) {
            this.start();
        } else {
            this.stop();
        }
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("autoRefreshInterval")) {
            PropertyChangeEvent changeEvent = evt.getPropertyChange("autoRefreshInterval");
            this.setMonitorInterval(((Integer)changeEvent.getNewValue()).longValue());
        }
    }
}

