/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage.monitor;

import com.atlassian.clover.Logger;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.coverage.monitor.AbstractCoverageMonitor;
import java.net.URL;

public class PropertyCoverageMonitor
extends AbstractCoverageMonitor
implements ConfigChangeListener {
    private final Logger LOG = Logger.getInstance("PropertyCoverageMonitor");
    private final CloverPluginConfig config;

    public PropertyCoverageMonitor(CloverPluginConfig data) {
        this.config = data;
    }

    @Override
    public void start() {
        this.config.addConfigChangeListener(this);
    }

    @Override
    public void stop() {
        this.config.removeConfigChangeListener(this);
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("span") || evt.hasPropertyChange("context") || evt.hasPropertyChange("regexpContexts") || evt.hasPropertyChange("relativeInitString") || evt.hasPropertyChange("manualInitString") || evt.hasPropertyChange("automaticInitString")) {
            this.updateManager((CloverPluginConfig)evt.getSource());
        }
    }

    private void updateManager(CloverPluginConfig data) {
        try {
            String context = data.getContextFilterSpec();
            String initString = data.getInitString();
            URL initUrl = new URL("file", "localhost", initString);
            this.coverageManager.setInitString(initUrl);
            this.coverageManager.setContextFilter(context);
            this.coverageManager.setSpan(new Interval(data.getSpan()).getValueInMillis());
            this.coverageManager.reload();
        }
        catch (Exception e) {
            this.LOG.error(e);
        }
    }
}

