/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.idea.coverage.PercentBarColors;
import com.atlassian.clover.idea.coverage.PercentBarRenderer;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PercentBarPanel
extends JPanel
implements TableCellRenderer {
    private float percent;
    private final PercentBarRenderer renderer;

    public PercentBarPanel() {
        this.renderer = new PercentBarRenderer();
    }

    public PercentBarPanel(PercentBarColors colors) {
        this.renderer = new PercentBarRenderer(colors);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int height = this.getHeight();
        int width = this.getWidth();
        this.renderer.renderBar(this, g, this.percent, width, height);
    }

    public void setPercent(float pc) {
        this.percent = pc;
        this.repaint();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.percent = ((Float)value).floatValue();
        }
        catch (ClassCastException e) {
            this.percent = -1.0f;
        }
        return this;
    }
}

