/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import com.atlassian.clover.util.Formatting;
import java.util.Collection;

public abstract class BaseCoverageNodeViewer {
    public void setNode(HasMetrics hasMetrics, TestPassInfo testPassInfo) {
        BlockMetrics metrics;
        BlockMetrics blockMetrics = metrics = hasMetrics != null ? hasMetrics.getMetrics() : null;
        if (testPassInfo != null) {
            if (testPassInfo.hasResults()) {
                this.setTestsPassedText(Formatting.formatInt(testPassInfo.getTestPasses()));
                this.setTestsRunText(Formatting.formatInt(testPassInfo.getTestsRun()));
            } else {
                this.setTestsPassedText("-");
                this.setTestsRunText("-");
            }
            this.setTestsFailedText(Formatting.formatInt(testPassInfo.getTestFailures()));
            this.setTestsErrorsText(Formatting.formatInt(testPassInfo.getTestErrors()));
            this.setPCTestsError(testPassInfo.getPcTestErrors());
            this.setPCTestsFailed(testPassInfo.getPcTestFailures());
            this.setPCTestsPassed(testPassInfo.getPcTestPasses());
        } else {
            this.setTestsPassedText("-");
            this.setTestsRunText("-");
            this.setTestsText(Formatting.formatInt(0));
            this.setTestsFailedText(Formatting.formatInt(0));
            this.setTestsErrorsText(Formatting.formatInt(0));
            this.setPCTestsError(-1.0f);
            this.setPCTestsFailed(-1.0f);
            this.setPCTestsPassed(-1.0f);
        }
        if (metrics != null) {
            this.setStmtsCoveredText(Formatting.formatInt(metrics.getNumCoveredStatements()) + " / " + Formatting.formatInt(metrics.getNumStatements()));
            this.setCondsCoveredText(Formatting.formatInt(metrics.getNumCoveredBranches()) + " / " + Formatting.formatInt(metrics.getNumBranches()));
            this.setTotalComplexityText(Formatting.formatInt(metrics.getComplexity()));
            this.setComplexityDensityText(Formatting.format2d(metrics.getComplexityDensity()));
            this.setStmtsPercent(metrics.getPcCoveredStatements());
            this.setCondsPercent(metrics.getPcCoveredBranches());
            this.setTotalPercent(metrics.getPcCoveredElements());
            this.setNumStatementsText(Formatting.formatInt(metrics.getNumStatements()));
            this.setNumBranchesText(Formatting.formatInt(metrics.getNumBranches()));
            this.setTestsText(Formatting.formatInt(metrics.getNumTests()));
            if (metrics instanceof ClassMetrics) {
                ClassMetrics classMetrics = (ClassMetrics)metrics;
                this.setMethodsCoveredText(Formatting.formatInt(classMetrics.getNumCoveredMethods()) + " / " + Formatting.formatInt(classMetrics.getNumMethods()));
                this.setMethodsPercent(classMetrics.getPcCoveredMethods());
                this.setNumMethodsText(Formatting.formatInt(classMetrics.getNumMethods()));
                this.setAvgComplexityText(Formatting.format2d(classMetrics.getAvgMethodComplexity()));
                this.setTestMethodsText(Formatting.formatInt(classMetrics.getNumTestMethods()));
            } else {
                this.setMethodsCoveredText("- / -");
                this.setMethodsPercent(-1.0f);
                this.setNumMethodsText("-");
                this.setAvgComplexityText("-");
            }
            if (metrics instanceof FileMetrics) {
                FileMetrics fileMetrics = (FileMetrics)metrics;
                this.setLOCText(Formatting.formatInt(fileMetrics.getLineCount()));
                this.setNCLOCText(Formatting.formatInt(fileMetrics.getNcLineCount()));
                this.setNumClassesText(Formatting.formatInt(fileMetrics.getNumClasses()));
            } else {
                this.setLOCText("-");
                this.setNCLOCText("-");
                this.setNumClassesText("-");
            }
            if (metrics instanceof ProjectMetrics) {
                this.setNumPackagesText(Formatting.formatInt(((ProjectMetrics)metrics).getNumPackages()));
            } else {
                this.setNumPackagesText("-");
            }
            if (metrics instanceof PackageMetrics) {
                this.setNumFilesText(Formatting.formatInt(((PackageMetrics)metrics).getNumFiles()));
            } else {
                this.setNumFilesText("-");
            }
            this.setExtraStatsVisible(true);
        } else {
            String nothing = "- / -";
            this.setMethodsCoveredText("- / -");
            this.setStmtsCoveredText("- / -");
            this.setCondsCoveredText("- / -");
            this.setMethodsPercent(-1.0f);
            this.setStmtsPercent(-1.0f);
            this.setCondsPercent(-1.0f);
            this.setTotalPercent(-1.0f);
            this.setExtraStatsVisible(false);
        }
    }

    protected abstract void setExtraStatsVisible(boolean var1);

    protected abstract void setNumPackagesText(String var1);

    protected abstract void setNumClassesText(String var1);

    protected abstract void setNumFilesText(String var1);

    protected abstract void setNumMethodsText(String var1);

    protected abstract void setNumStatementsText(String var1);

    protected abstract void setNumBranchesText(String var1);

    protected abstract void setNCLOCText(String var1);

    protected abstract void setLOCText(String var1);

    protected abstract void setTotalPercent(float var1);

    protected abstract void setCondsPercent(float var1);

    protected abstract void setStmtsPercent(float var1);

    protected abstract void setMethodsPercent(float var1);

    protected abstract void setCondsCoveredText(String var1);

    protected abstract void setStmtsCoveredText(String var1);

    protected abstract void setMethodsCoveredText(String var1);

    protected abstract void setTotalComplexityText(String var1);

    protected abstract void setAvgComplexityText(String var1);

    protected abstract void setComplexityDensityText(String var1);

    protected abstract void setTestMethodsText(String var1);

    protected abstract void setTestsText(String var1);

    protected abstract void setTestsRunText(String var1);

    protected abstract void setTestsPassedText(String var1);

    protected abstract void setTestsFailedText(String var1);

    protected abstract void setTestsErrorsText(String var1);

    protected abstract void setPCTestsPassed(float var1);

    protected abstract void setPCTestsFailed(float var1);

    protected abstract void setPCTestsError(float var1);

    public static class TestPassInfo {
        private int testPasses;
        private int testFailures;
        private int testErrors;
        private final int testsRun;

        public TestPassInfo(Collection<TestCaseInfo> testRuns) {
            for (TestCaseInfo hit : testRuns) {
                if (hit.isSuccess()) {
                    ++this.testPasses;
                    continue;
                }
                if (hit.isFailure()) {
                    ++this.testFailures;
                    continue;
                }
                if (!hit.isError()) continue;
                ++this.testErrors;
            }
            this.testsRun = this.testPasses + this.testFailures + this.testErrors;
        }

        public TestPassInfo(BlockMetrics metrics) {
            this.testPasses = metrics.getNumTestPasses();
            this.testFailures = metrics.getNumTestFailures();
            this.testErrors = metrics.getNumTestErrors();
            this.testsRun = metrics.getNumTestsRun();
        }

        public int getTestFailures() {
            return this.testFailures;
        }

        public int getTestPasses() {
            return this.testPasses;
        }

        public int getTestErrors() {
            return this.testErrors;
        }

        public int getTestsRun() {
            return this.testsRun;
        }

        public boolean hasResults() {
            return this.testsRun != 0;
        }

        public float getPcTestPasses() {
            return this.getFraction(this.testPasses, this.testsRun);
        }

        public float getPcTestErrors() {
            return this.getFraction(this.testErrors, this.testsRun);
        }

        public float getPcTestFailures() {
            return this.getFraction(this.testFailures, this.testsRun);
        }

        private float getFraction(int num, int dem) {
            if (dem != 0) {
                return (float)num / (float)dem;
            }
            return -1.0f;
        }
    }
}

