/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.content;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.content.CloverRangeMarkerRenderer;
import com.atlassian.clover.idea.content.ContentPlugin;
import com.atlassian.clover.idea.coverage.ModelUtil;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.atlassian.clover.idea.feature.FeatureManager;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.MetricsFormatUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.openclover.util.Lists;

public class DocMarkupPlugin
extends ContentPlugin
implements FeatureListener,
ConfigChangeListener {
    private final List<RangeHighlighter> highlights = Lists.newArrayList();
    private boolean enabled;

    public DocMarkupPlugin(Project proj, VirtualFile vf) {
        super(proj, vf);
    }

    @Override
    public void install(Editor e) {
        super.install(e);
        FeatureManager fManager = ProjectPlugin.getPlugin(this.project).getFeatureManager();
        fManager.addFeatureListener("clover-reporting", this);
        this.enabled = fManager.isFeatureEnabled("clover-reporting");
        ProjectPlugin.getPlugin(this.project).getConfig().addConfigChangeListener(this);
        this.updateMarkups();
    }

    @Override
    public void uninstall() {
        ProjectPlugin.getPlugin(this.project).getConfig().removeConfigChangeListener(this);
        FeatureManager fManager = ProjectPlugin.getPlugin(this.project).getFeatureManager();
        fManager.removeFeatureListener("clover-reporting", this);
        this.clearMarkups();
        super.uninstall();
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("showErrorMarks") || evt.hasPropertyChange("showGutter") || evt.hasPropertyChange("showInline") || evt.hasPropertyChange("highlightCovered") || evt.hasPropertyChange("coveredHighlight") || evt.hasPropertyChange("coveredStripe") || evt.hasPropertyChange("notCoveredHighlight") || evt.hasPropertyChange("notCoveredStripe") || evt.hasPropertyChange("failedCoveredHighlight") || evt.hasPropertyChange("failedCoveredStripe") || evt.hasPropertyChange("filteredHighlight") || evt.hasPropertyChange("filteredStripe") || evt.hasPropertyChange("outOfDateHighlight") || evt.hasPropertyChange("outOfDateStripe") || evt.hasPropertyChange("includePassedTestCoverageOnly")) {
            this.updateMarkups();
        }
    }

    @Override
    public void featureStateChanged(FeatureEvent evt) {
        if (this.enabled != evt.isEnabled()) {
            this.enabled = evt.isEnabled();
            this.updateMarkups();
        }
    }

    private void updateMarkups() {
        this.clearMarkups();
        if (!this.enabled) {
            return;
        }
        if (this.coverageInfo == null) {
            return;
        }
        if (this.installedEditor == null) {
            return;
        }
        if (this.isCoverageUpToDate()) {
            CloverDatabase cloverDatabase = this.currentCoverageModel != null ? this.currentCoverageModel.getCloverDatabase() : null;
            FullFileInfo fileInfo = cloverDatabase != null && ModelUtil.isPassedTestsCoverageOnly(cloverDatabase) ? this.coverageInfo.copy((FullPackageInfo)this.coverageInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL) : this.coverageInfo;
            new HighlightMarkupBuilder(ProjectPlugin.getPlugin(this.project).getConfig()).process(fileInfo);
        } else if (this.hasPotentialCloverableElements()) {
            int end = this.installedEditor.getDocument().getTextLength();
            RangeHighlighter rangeHighlighter = this.installedEditor.getMarkupModel().addRangeHighlighter(0, end, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
            Color c = ProjectPlugin.getPlugin(this.project).getConfig().getOutOfDateStripe();
            rangeHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new CloverRangeMarkerRenderer(c));
            this.highlights.add(rangeHighlighter);
        }
    }

    private void clearMarkups() {
        if (this.installedEditor != null) {
            MarkupModel markup = this.installedEditor.getMarkupModel();
            for (RangeHighlighter highlighter : this.highlights) {
                if (highlighter == null) continue;
                markup.removeHighlighter(highlighter);
            }
        }
        this.highlights.clear();
    }

    @Override
    public void refresh() {
        this.updateMarkups();
    }

    static class CoverageBlock {
        public Style style;
        public int startLine;
        public int endLine;

        CoverageBlock() {
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getLength() {
            return this.getEndLine() - this.getStartLine() + 1;
        }

        public Style getStyle() {
            return this.style;
        }

        static enum Style {
            GOOD,
            FAILED_ONLY,
            BAD,
            OLD,
            FILTERED;

        }
    }

    private class HighlightMarkupBuilder {
        public final boolean showGutter;
        public final boolean showError;
        public final boolean showHighlight;
        public final boolean highlightCovered;
        public final boolean includeFailedCoverage;
        public final Color coveredHighlight;
        public final Color coveredStripe;
        public final Color notCoveredHighlight;
        public final Color notCoveredStripe;
        public final Color outOfDateHighlight;
        public final Color outOfDateStripe;
        public final Color excludedHighlight;
        public final Color excludedStripe;
        public final Color failedOnlyHighlight;
        public final Color failedOnlyStripe;
        private final MarkupModel markup;
        private final Document doc;
        private final boolean uptodate;
        private final CoverageBlock.Style[] lineStatus;
        private ContextSet filter;
        private final CoverageDataProvider fullDataProvider;
        private final CoverageDataProvider passedTestDataProvider;

        private HighlightMarkupBuilder(IdeaCloverConfig config) {
            this.markup = DocMarkupPlugin.this.installedEditor.getMarkupModel();
            this.doc = DocMarkupPlugin.this.installedEditor.getDocument();
            this.uptodate = DocMarkupPlugin.this.isCoverageUpToDate();
            this.lineStatus = new CoverageBlock.Style[this.doc.getLineCount()];
            CloverDatabase cloverDatabase = DocMarkupPlugin.this.currentCoverageModel != null ? DocMarkupPlugin.this.currentCoverageModel.getCloverDatabase() : null;
            this.fullDataProvider = cloverDatabase != null ? cloverDatabase.getCoverageData() : null;
            this.passedTestDataProvider = DocMarkupPlugin.this.currentCoverageModel != null ? DocMarkupPlugin.this.currentCoverageModel.getCachedPassOnlyCoverage() : null;
            this.showGutter = config.isShowGutter();
            this.showError = config.isShowErrorMarks();
            this.showHighlight = config.isShowInline();
            this.highlightCovered = config.isHighlightCovered();
            this.coveredHighlight = config.getCoveredHighlight();
            this.notCoveredHighlight = config.getNotCoveredHighlight();
            this.notCoveredStripe = config.getNotCoveredStripe();
            this.outOfDateStripe = config.getOutOfDateStripe();
            this.outOfDateHighlight = config.getOutOfDateHighlight();
            this.coveredStripe = config.getCoveredStripe();
            this.excludedHighlight = config.getFilteredHighlight();
            this.excludedStripe = config.getFilteredStripe();
            this.failedOnlyHighlight = config.getFailedCoveredHighlight();
            this.failedOnlyStripe = config.getFailedCoveredStripe();
            this.includeFailedCoverage = !config.isIncludePassedTestCoverageOnly();
        }

        void process(FullFileInfo coverageInfo) {
            this.filter = coverageInfo.getContextFilter();
            if (this.showHighlight || this.showError || this.showGutter) {
                for (SourceInfo o : coverageInfo.getSourceRegions()) {
                    if (!(o instanceof FullElementInfo)) continue;
                    if (this.showHighlight || this.showError) {
                        this.highlightStatement((FullElementInfo)o);
                    }
                    if (!this.showGutter) continue;
                    this.markLines((FullElementInfo)o);
                }
                if (this.showGutter) {
                    this.createGutterMarks();
                }
            }
        }

        private void markLines(FullElementInfo info) {
            if (this.uptodate) {
                boolean isFiltered = info.isFiltered(this.filter);
                boolean passedOnlyHit = this.passedTestDataProvider.getHitCount(info.getDataIndex()) > 0;
                boolean anyHit = this.fullDataProvider.getHitCount(info.getDataIndex()) > 0;
                for (int i = info.getStartLine() - 1; i < info.getEndLine(); ++i) {
                    if (isFiltered) {
                        this.lineStatus[i] = CoverageBlock.Style.FILTERED;
                        continue;
                    }
                    if (passedOnlyHit) {
                        if (this.lineStatus[i] != null) continue;
                        this.lineStatus[i] = CoverageBlock.Style.GOOD;
                        continue;
                    }
                    if (anyHit && this.includeFailedCoverage) {
                        if (this.lineStatus[i] != null && this.lineStatus[i] != CoverageBlock.Style.GOOD) continue;
                        this.lineStatus[i] = CoverageBlock.Style.FAILED_ONLY;
                        continue;
                    }
                    this.lineStatus[i] = CoverageBlock.Style.BAD;
                }
            } else {
                for (int i = info.getStartLine() - 1; i < info.getEndLine(); ++i) {
                    this.lineStatus[i] = CoverageBlock.Style.OLD;
                }
            }
        }

        private void highlightStatement(FullElementInfo info) {
            Color stripeColor;
            Color bgColor;
            int statementEnd;
            int statementStart = this.doc.getLineStartOffset(info.getStartLine() - 1) + info.getStartColumn() - 1;
            if (statementStart > (statementEnd = this.doc.getLineStartOffset(info.getEndLine() - 1) + info.getEndColumn() - 1)) {
                int v = statementStart;
                statementStart = statementEnd;
                statementEnd = v;
            }
            TextAttributes statementTextAttributes = new TextAttributes();
            RangeHighlighter statementHighlight = this.markup.addRangeHighlighter(statementStart, statementEnd, 4000, statementTextAttributes, HighlighterTargetArea.EXACT_RANGE);
            boolean passedOnlyHit = this.passedTestDataProvider.getHitCount(info.getDataIndex()) > 0;
            boolean anyHit = this.fullDataProvider.getHitCount(info.getDataIndex()) > 0;
            boolean isFiltered = false;
            if (this.uptodate) {
                isFiltered = info.isFiltered(this.filter);
                if (isFiltered) {
                    bgColor = this.excludedHighlight;
                    stripeColor = this.excludedStripe;
                } else if (passedOnlyHit) {
                    bgColor = this.coveredHighlight;
                    stripeColor = this.coveredStripe;
                } else if (anyHit && this.includeFailedCoverage) {
                    bgColor = this.failedOnlyHighlight;
                    stripeColor = this.failedOnlyStripe;
                } else {
                    bgColor = this.notCoveredHighlight;
                    stripeColor = this.notCoveredStripe;
                }
            } else {
                bgColor = this.outOfDateHighlight;
                stripeColor = this.outOfDateStripe;
            }
            if (this.showHighlight) {
                if (!anyHit || this.highlightCovered || isFiltered) {
                    statementTextAttributes.setBackgroundColor(bgColor);
                }
                if (info instanceof BranchInfo) {
                    BranchInfo branchInfo = (BranchInfo)((Object)info);
                    statementTextAttributes.setEffectType(EffectType.LINE_UNDERSCORE);
                    Color underlineColor = branchInfo.getFalseHitCount() != 0 && branchInfo.getTrueHitCount() != 0 ? this.coveredStripe : this.notCoveredStripe;
                    statementTextAttributes.setEffectColor(underlineColor);
                }
            }
            if (this.showError) {
                statementHighlight.setErrorStripeMarkColor(stripeColor);
                statementHighlight.setErrorStripeTooltip((Object)(this.uptodate ? MetricsFormatUtils.textForCoverage(info) : "Coverage data out of date"));
            }
            DocMarkupPlugin.this.highlights.add(statementHighlight);
        }

        private List<CoverageBlock> aggregateLines() {
            ArrayList<CoverageBlock> styles = Lists.newArrayList();
            int line = 0;
            while (line < this.lineStatus.length) {
                CoverageBlock current = new CoverageBlock();
                current.style = this.lineStatus[line];
                current.startLine = line;
                while (++line < this.lineStatus.length && current.style == this.lineStatus[line]) {
                }
                current.endLine = line - 1;
                styles.add(current);
            }
            return styles;
        }

        private void createGutterMarks() {
            if (!this.showGutter) {
                return;
            }
            EnumMap<CoverageBlock.Style, Color> colorMap = new EnumMap<CoverageBlock.Style, Color>(CoverageBlock.Style.class);
            colorMap.put(CoverageBlock.Style.BAD, this.notCoveredStripe);
            colorMap.put(CoverageBlock.Style.FILTERED, this.excludedStripe);
            colorMap.put(CoverageBlock.Style.GOOD, this.coveredStripe);
            colorMap.put(CoverageBlock.Style.FAILED_ONLY, this.failedOnlyStripe);
            colorMap.put(CoverageBlock.Style.OLD, this.outOfDateStripe);
            List<CoverageBlock> styles = this.aggregateLines();
            for (CoverageBlock block : styles) {
                if (block.getStyle() == null) continue;
                int startOffset = DocMarkupPlugin.this.installedEditor.getDocument().getLineStartOffset(block.getStartLine());
                int endOffset = DocMarkupPlugin.this.installedEditor.getDocument().getLineEndOffset(block.getEndLine());
                RangeHighlighter rangeHighlight = this.markup.addRangeHighlighter(startOffset, endOffset, 3500, null, HighlighterTargetArea.LINES_IN_RANGE);
                rangeHighlight.setLineMarkerRenderer((LineMarkerRenderer)new CloverRangeMarkerRenderer((Color)colorMap.get((Object)block.getStyle())));
                DocMarkupPlugin.this.highlights.add(rangeHighlight);
            }
        }
    }
}

