/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config.regexp;

import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.config.regexp.RegexpValidator;
import com.atlassian.clover.idea.util.ComparatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class RegexpConfigModel
extends Observable
implements Observer {
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String EDIT = "edit";
    public static final String SELECTED = "selected";
    private List<Regexp> regexps = Lists.newArrayList();
    private Regexp currentRegexp;
    private String errorMessage;
    private final ContextStore context;
    private final ModelContextRegexpValidator modelContextRegexpValidator = new ModelContextRegexpValidator();

    public RegexpValidator getModelContextRegexpValidator() {
        return this.modelContextRegexpValidator;
    }

    public RegexpConfigModel(ContextStore context) {
        this.context = context;
    }

    public List<Regexp> getRegexps() {
        return this.regexps;
    }

    public Regexp getSelected() {
        return this.currentRegexp;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setSelected(Regexp regexp) {
        if (regexp != null && !this.regexps.contains(regexp)) {
            throw new IllegalArgumentException("Can not select unknown regexp.");
        }
        if (ComparatorUtil.areDifferent(regexp, this.currentRegexp)) {
            this.currentRegexp = regexp;
            this.setChanged();
        }
        this.notifyObservers(SELECTED);
    }

    public void loadFrom(CloverPluginConfig config) {
        this.regexps.clear();
        this.currentRegexp = null;
        this.errorMessage = null;
        for (Regexp c : config.getRegexpContexts()) {
            Regexp r = new Regexp(c, (RegexpValidator)this.modelContextRegexpValidator);
            r.addObserver(this);
            this.regexps.add(r);
        }
        this.setChanged();
        this.notifyObservers();
        this.modelContextRegexpValidator.verifyDuplicateNames();
    }

    public void commitTo(CloverPluginConfig config) {
        ArrayList<Regexp> l = new ArrayList<Regexp>(this.regexps.size());
        for (Regexp r : this.regexps) {
            l.add(new Regexp(r));
        }
        config.setRegexpContexts(l);
    }

    public void add(Regexp regexp) {
        this.regexps.add(regexp);
        regexp.addObserver(this);
        this.setChanged();
        this.notifyObservers(ADD);
    }

    public void remove(Regexp regexp) {
        int indexOf = this.regexps.indexOf(regexp);
        if (indexOf == -1) {
            throw new IllegalArgumentException("Can not remove unknown regexp: " + regexp);
        }
        regexp.deleteObserver(this);
        this.regexps.remove(regexp);
        this.setChanged();
        this.notifyObservers(REMOVE);
        this.currentRegexp = this.regexps.size() > indexOf ? this.regexps.get(indexOf) : (this.regexps.size() == 0 ? null : this.regexps.get(this.regexps.size() - 1));
        this.setChanged();
        this.notifyObservers(SELECTED);
        this.modelContextRegexpValidator.verifyDuplicateNames();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers(EDIT);
    }

    private class ModelContextRegexpValidator
    extends RegexpValidator {
        private ModelContextRegexpValidator() {
        }

        @Override
        public void validate(Regexp validatedRegexp) {
            String name = validatedRegexp.getName();
            NamedContext existingContext = RegexpConfigModel.this.context.getContext(name);
            if (existingContext != null) {
                validatedRegexp.setChanged(validatedRegexp.isDifferent(existingContext));
            } else {
                validatedRegexp.setChanged(true);
            }
            super.validate(validatedRegexp);
            this.verifyDuplicateNames();
            if (ContextStore.isReservedName(name)) {
                validatedRegexp.setValidationMessage("Name '" + name + "' is reserved.");
            }
        }

        private void verifyDuplicateNames() {
            HashMap map = Maps.newHashMap();
            for (Regexp regexp : RegexpConfigModel.this.regexps) {
                String name = regexp.getName();
                Regexp previous = (Regexp)map.get(name);
                if (previous != null) {
                    previous.setValidationMessage("Duplicate name");
                    regexp.setValidationMessage("Duplicate name");
                    continue;
                }
                super.validate(regexp);
                map.put(name, regexp);
            }
        }
    }
}

