/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config.regexp;

import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.context.RegexpContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.idea.config.ContextFilterRegexpType;
import com.atlassian.clover.idea.config.regexp.RegexpValidator;
import com.atlassian.clover.idea.util.ComparatorUtil;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regexp
extends Observable {
    private String name;
    private int type;
    private String regex;
    private boolean changed;
    private boolean enabled;
    private String validationMessage;
    private RegexpValidator validator;

    public Regexp() {
        this(RegexpValidator.CONTEXTLESS_VALIDATOR);
    }

    public Regexp(RegexpValidator validator) {
        this.validator = validator;
    }

    public Regexp(Regexp other) {
        this(other, other.validator);
    }

    public Regexp(Regexp other, RegexpValidator validator) {
        this.name = other.name;
        this.type = other.type;
        this.regex = other.regex;
        this.changed = other.changed;
        this.enabled = other.enabled;
        this.validator = validator;
        this.validate();
    }

    public Regexp(RegexpContext other, RegexpValidator validator) {
        this.name = other.getName();
        this.type = other instanceof MethodRegexpContext ? ContextFilterRegexpType.Method.ordinal() : ContextFilterRegexpType.Statement.ordinal();
        this.regex = other.getPattern().pattern();
        this.validator = validator;
        this.validate();
    }

    public void copyFrom(Regexp other) {
        this.setName(other.getName());
        this.setType(other.getType());
        this.setRegex(other.getRegex());
        this.setChanged(other.isChanged());
        this.setEnabled(other.isEnabled());
        this.validator = other.validator;
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (ComparatorUtil.areDifferent(this.name, name)) {
            this.name = name;
            this.validate();
            this.setChanged();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.type != type) {
            this.type = type;
            this.validate();
            this.setChanged();
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        if (ComparatorUtil.areDifferent(this.regex, regex)) {
            this.regex = regex;
            this.validate();
            this.setChanged();
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        if (this.changed != changed) {
            this.changed = changed;
            this.setChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.setChanged();
        }
    }

    public RegexpContext toContextSetting() {
        Pattern regexpPattern = Pattern.compile(this.getRegex());
        return this.type == ContextFilterRegexpType.Method.ordinal() ? new MethodRegexpContext(this.getName(), regexpPattern) : new StatementRegexpContext(this.getName(), regexpPattern);
    }

    public static String suggestNewName(List<Regexp> existing) {
        return Regexp.suggestName("Unnamed_{0}", existing);
    }

    public static String suggestCopyName(Regexp ctx, List<Regexp> existing) {
        return Regexp.suggestName("Copy_{0}_of_" + ctx.getName(), existing);
    }

    public static String suggestName(String template, List<Regexp> existing) {
        String regexp = MessageFormat.format(template, "(\\d+)");
        Pattern pattern = Pattern.compile(regexp);
        long maxIndex = 0L;
        for (Regexp regex : existing) {
            long index;
            Matcher m = pattern.matcher(regex.getName());
            if (!m.matches() || (index = Long.parseLong(m.group(1))) <= maxIndex) continue;
            maxIndex = index;
        }
        return MessageFormat.format(template, maxIndex + 1L);
    }

    public boolean isValid() {
        return this.validationMessage == null;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void validate() {
        this.validator.validate(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDifferent(NamedContext context) {
        RegexpContext regexpContext;
        if (this.type == ContextFilterRegexpType.Method.ordinal()) {
            if (!(context instanceof MethodRegexpContext)) return true;
            regexpContext = (RegexpContext)context;
        } else {
            if (!(context instanceof StatementRegexpContext)) return true;
            regexpContext = (RegexpContext)context;
        }
        if (!this.name.equals(context.getName())) {
            return true;
        }
        if (this.regex != null) {
            if (this.regex.equals(regexpContext.getPattern().pattern())) return false;
            return true;
        }
        if (regexpContext.getPattern() != null) return true;
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regexp regexp = (Regexp)o;
        if (this.enabled != regexp.enabled) {
            return false;
        }
        if (this.type != regexp.type) {
            return false;
        }
        if (this.name != null ? !this.name.equals(regexp.name) : regexp.name != null) {
            return false;
        }
        return !(this.regex == null ? regexp.regex != null : !this.regex.equals(regexp.regex));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.type;
        result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }
}

