/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.util.ui.UIUtils;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RefreshPolicyConfigPanel
extends ConfigPanel
implements ActionListener {
    private JTextArea helpText;
    private JRadioButton directedButton;
    private JRadioButton autoButton;
    private JRadioButton periodicButton;
    private ButtonGroup buttonGroup;
    private JTextField intervalField;
    private JLabel intervalLabelB;

    public RefreshPolicyConfigPanel() {
        this.initLayout();
        this.initListeners();
        this.refreshState();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        this.setLayout((LayoutManager)new VerticalFlowLayout());
        this.add(this.getHelpText());
        this.add(this.getManualButton());
        this.add(this.getAutoButton());
        Box periodicPanel = Box.createHorizontalBox();
        periodicPanel.add(this.getPeriodicButton());
        periodicPanel.add(this.getIntervalInput());
        periodicPanel.add(this.getPostIntervalInputLabel());
        periodicPanel.add(Box.createHorizontalGlue());
        this.add(periodicPanel);
    }

    private void initListeners() {
        this.getManualButton().addActionListener(this);
        this.getAutoButton().addActionListener(this);
        this.getPeriodicButton().addActionListener(this);
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        config.setAutoRefresh(this.getAutoButton().isSelected());
        config.setPeriodicRefresh(this.getPeriodicButton().isSelected());
        String interval = this.getIntervalInput().getText();
        try {
            config.setAutoRefreshInterval(Integer.parseInt(interval));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        this.getAutoButton().setSelected(config.isAutoRefresh());
        this.getPeriodicButton().setSelected(config.isPeriodicRefresh());
        this.getIntervalInput().setText("" + config.getAutoRefreshInterval());
        this.refreshState();
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("The Refresh Policy controls when and how frequently Clover looks for a change in coverage data.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JRadioButton getManualButton() {
        if (this.directedButton == null) {
            URL image = this.getClass().getResource("/icons/sync.png");
            String message = String.format("<html>Manual: press %s to refresh.", image != null ? "<img src='" + image + "'>" : "Refresh");
            this.directedButton = new JRadioButton(message);
            this.getButtonGroup().add(this.directedButton);
            this.directedButton.setSelected(true);
        }
        return this.directedButton;
    }

    private JRadioButton getAutoButton() {
        if (this.autoButton == null) {
            this.autoButton = new JRadioButton("Automatic: after compilation or process finishes.");
            this.getButtonGroup().add(this.autoButton);
        }
        return this.autoButton;
    }

    private JRadioButton getPeriodicButton() {
        if (this.periodicButton == null) {
            this.periodicButton = new JRadioButton("Periodically every ");
            this.getButtonGroup().add(this.periodicButton);
        }
        return this.periodicButton;
    }

    private JLabel getPostIntervalInputLabel() {
        if (this.intervalLabelB == null) {
            this.intervalLabelB = new JLabel(" msecs");
        }
        return this.intervalLabelB;
    }

    private JTextField getIntervalInput() {
        if (this.intervalField == null) {
            this.intervalField = new JTextField();
            this.intervalField.setColumns(6);
            this.intervalField.setMaximumSize(this.intervalField.getPreferredSize());
        }
        return this.intervalField;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    @Override
    public String getTitle() {
        return "Refresh Policy";
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.getManualButton() || src == this.getAutoButton() || src == this.getPeriodicButton()) {
            this.refreshState();
        }
    }

    @Override
    public void enableConfig(boolean b) {
        super.enableConfig(b);
        this.getManualButton().setForeground(b ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
        if (b) {
            this.refreshState();
        }
    }

    private void refreshState() {
        boolean enableIntervalInput = this.getPeriodicButton().isSelected() && this.isEnabled();
        this.getIntervalInput().setEnabled(enableIntervalInput);
        this.getPostIntervalInputLabel().setEnabled(enableIntervalInput);
    }
}

