/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.ProjectRebuild;
import com.atlassian.clover.idea.util.ui.RichLabel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class ProjectRebuildConfigPanel
extends ConfigPanel {
    private static final String TITLE = "Rebuild policy";
    private static final String DESCRIPTION = "<html>Clover requires that the project is rebuilt every time the <i>Build with Clover</i> is toggled or coverage database is purged.";
    private final JLabel description = new RichLabel("<html>Clover requires that the project is rebuilt every time the <i>Build with Clover</i> is toggled or coverage database is purged.");
    private final JRadioButton askButton = new JRadioButton("Ask");
    private final JRadioButton alwaysButton = new JRadioButton("Rebuild immediately");
    private final JRadioButton neverButton = new JRadioButton("Never rebuild automatically");
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public ProjectRebuildConfigPanel() {
        this.buttonGroup.add(this.askButton);
        this.buttonGroup.add(this.alwaysButton);
        this.buttonGroup.add(this.neverButton);
        this.setLayout((LayoutManager)new VerticalFlowLayout());
        this.add(this.description);
        this.add(this.askButton);
        this.add(this.alwaysButton);
        this.add(this.neverButton);
    }

    private ProjectRebuild getSelection() {
        return this.neverButton.isSelected() ? ProjectRebuild.NEVER : (this.alwaysButton.isSelected() ? ProjectRebuild.ALWAYS : ProjectRebuild.ASK);
    }

    @Override
    public void commitTo(CloverPluginConfig data) {
        data.setProjectRebuild(this.getSelection());
    }

    @Override
    public void loadFrom(CloverPluginConfig data) {
        ProjectRebuild rebuild = data.getProjectRebuild();
        switch (rebuild) {
            case ASK: {
                this.askButton.setSelected(true);
                break;
            }
            case ALWAYS: {
                this.alwaysButton.setSelected(true);
                break;
            }
            case NEVER: {
                this.neverButton.setSelected(true);
            }
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }
}

