/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.idea.config.AbstractCloverPluginConfig;
import com.atlassian.clover.idea.config.ProjectRebuild;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.util.collections.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class MappedCloverPluginConfig
extends AbstractCloverPluginConfig {
    public static final String ENABLED = "enabled";
    public static final String MANUAL_INIT_STRING = "manualInitString";
    public static final String AUTO_INIT_STRING = "automaticInitString";
    public static final String RELATIVE_INIT_STRING = "relativeInitString";
    public static final String FLUSH_POLICY = "flushPolicy";
    public static final String FLUSH_INTERVAL = "flushInterval";
    public static final String SPAN = "span";
    public static final String INCLUDES = "includes";
    public static final String EXCLUDES = "excludes";
    public static final String CONTEXT = "context";
    public static final String SHOW_GUTTER = "showGutter";
    public static final String SHOW_TOOLTIPS = "showTooltips";
    public static final String SHOW_INLINE = "showInline";
    public static final String AUTO_REFRESH = "autoRefresh";
    public static final String PERIODIC_REFRESH = "periodicRefresh";
    public static final String AUTO_REFRESH_INTERVAL = "autoRefreshInterval";
    public static final String REGEXP_CONTEXTS = "regexpContexts";
    public static final String COVERED_STRIPE = "coveredStripe";
    public static final String COVERED_HIGHLIGHT = "coveredHighlight";
    public static final String FAILED_COVERED_STRIPE = "failedCoveredStripe";
    public static final String FAILED_COVERED_HIGHLIGHT = "failedCoveredHighlight";
    public static final String NOT_COVERED_STRIPE = "notCoveredStripe";
    public static final String NOT_COVERED_HIGHLIGHT = "notCoveredHighlight";
    public static final String OUTOFDATE_STRIPE = "outOfDateStripe";
    public static final String OUTOFDATE_HIGHLIGHT = "outOfDateHighlight";
    public static final String FILTERED_STRIPE = "filteredStripe";
    public static final String FILTERED_HIGHLIGHT = "filteredHighlight";
    public static final String LOAD_PER_TEST_DATA = "loadPerTestData";
    public static final String PROJECT_REBUILD = "projectRebuild";
    public static final String LANGUAGE_LEVEL = "languageLevel";
    public static final String GENERATED_INIT_STRING = "generatedInitString";
    public static final String BUILD_WITH_CLOVER = "buildWithClover";
    public static final String INSTRUMENT_TESTS = "instrumentTests";
    public static final String INSTRUMENT_LAMBDA = "instrumentLambda";
    public static final String DUMP_INSTRUMENTED_SOURCES = "dumpInstrumentedSources";
    public static final boolean DEFAULT_AUTO_INIT_STRING = true;
    public static final boolean DEFAULT_RELATIVE_INIT_STRING = false;
    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_FLUSH_POLICY = 0;
    public static final int DEFAULT_FLUSH_INTERVAL = 5000;
    public static final String DEFAULT_SPAN = "0";
    public static final String DEFAULT_CONTEXT = "";
    public static final boolean DEFAULT_SHOW_GUTTER = true;
    public static final boolean DEFAULT_SHOW_INLINE = true;
    public static final boolean DEFAULT_SHOW_TOOLTIPS = true;
    public static final boolean DEFAULT_AUTO_REFRESH = true;
    public static final boolean DEFAULT_PERIODIC_REFRESH = false;
    public static final int DEFAULT_AUTO_REFRESH_INTERVAL = 2000;
    public static final List DEFAULT_REGEXP_CONTEXTS = Lists.newArrayList();
    public static final Color DEFAULT_LIGHT_COVERED_STRIPE = Color.GREEN;
    public static final Color DEFAULT_LIGHT_COVERED_HIGHLIGHT = new Color(13171400);
    public static final Color DEFAULT_LIGHT_FAILED_COVERED_STRIPE = Color.ORANGE;
    public static final Color DEFAULT_LIGHT_FAILED_COVERED_HIGHLIGHT = new Color(0xFFF0B0);
    public static final Color DEFAULT_LIGHT_NOT_COVERED_STRIPE = Color.RED;
    public static final Color DEFAULT_LIGHT_NOT_COVERED_HIGHLIGHT = new Color(16435400);
    public static final Color DEFAULT_LIGHT_OUTOFDATE_STRIPE = Color.YELLOW;
    public static final Color DEFAULT_LIGHT_OUTOFDATE_HIGHLIGHT = new Color(0xFFFFE0);
    public static final Color DEFAULT_LIGHT_FILTERED_STRIPE = Color.DARK_GRAY;
    public static final Color DEFAULT_LIGHT_FILTERED_HIGHLIGHT = Color.LIGHT_GRAY;
    public static final Color DEFAULT_DARCULA_COVERED_STRIPE = Color.GREEN;
    public static final Color DEFAULT_DARCULA_COVERED_HIGHLIGHT = new Color(0, 80, 0);
    public static final Color DEFAULT_DARCULA_FAILED_COVERED_STRIPE = Color.ORANGE;
    public static final Color DEFAULT_DARCULA_FAILED_COVERED_HIGHLIGHT = new Color(80, 80, 0);
    public static final Color DEFAULT_DARCULA_NOT_COVERED_STRIPE = Color.RED;
    public static final Color DEFAULT_DARCULA_NOT_COVERED_HIGHLIGHT = new Color(80, 0, 0);
    public static final Color DEFAULT_DARCULA_OUTOFDATE_STRIPE = Color.YELLOW;
    public static final Color DEFAULT_DARCULA_OUTOFDATE_HIGHLIGHT = new Color(15);
    public static final Color DEFAULT_DARCULA_FILTERED_STRIPE = Color.LIGHT_GRAY;
    public static final Color DEFAULT_DARCULA_FILTERED_HIGHLIGHT = new Color(80, 80, 80);
    public static final boolean DEFAULT_LOAD_PER_TEST_DATA = true;
    public static final ProjectRebuild DEFAULT_PROJECT_REBUILD = ProjectRebuild.ASK;
    public static final String DEFAULT_GENERATED_INIT_STRING = "coverage.db";
    public static final boolean DEFAULT_BUILD_WITH_CLOVER = true;
    public static final boolean DEFAULT_INSTRUMENT_TESTS = true;
    public static final boolean DEFAULT_DUMP_INSTRUMENTED_SOURCES = false;
    public static final LambdaInstrumentation DEFAULT_INSTRUMENT_LAMBDA = LambdaInstrumentation.NONE;
    protected final Map<String, Object> properties = Maps.newHashMap();

    @Override
    public void writeProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    @Nullable
    public Object readProperty(String name) {
        return this.properties.get(name);
    }

    public Color getColorProperty(String name) {
        Pair colorPair = (Pair)this.getProperty(name);
        return MappedCloverPluginConfig.isUnderDarcula() ? (Color)colorPair.second : (Color)colorPair.first;
    }

    public void putColorProperty(String name, Color color) {
        Pair colourPair = (Pair)this.getProperty(name);
        if (colourPair != null) {
            this.putProperty(name, MappedCloverPluginConfig.isUnderDarcula() ? Pair.of(colourPair.first, color) : Pair.of(color, colourPair.second));
        } else {
            this.putProperty(name, Pair.of(color, color));
        }
    }

    private static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    @Override
    public String getInitString() {
        if (this.getUseGeneratedInitString()) {
            return this.getGeneratedInitString();
        }
        return this.getManualInitString();
    }

    public void setGeneratedInitString(String generatedInitString) {
        this.putProperty(GENERATED_INIT_STRING, generatedInitString);
    }

    @Override
    public String getGeneratedInitString() {
        return (String)this.getProperty(GENERATED_INIT_STRING, DEFAULT_GENERATED_INIT_STRING);
    }

    @Override
    public String getManualInitString() {
        return (String)this.getProperty(MANUAL_INIT_STRING);
    }

    @Override
    public void setManualInitString(String str) {
        this.putProperty(MANUAL_INIT_STRING, str);
    }

    @Override
    public void setUseGeneratedInitString(boolean b) {
        this.putProperty(AUTO_INIT_STRING, b);
    }

    @Override
    public boolean getUseGeneratedInitString() {
        return this.getBooleanProperty(AUTO_INIT_STRING, true);
    }

    @Override
    public boolean isRelativeInitString() {
        return this.getBooleanProperty(RELATIVE_INIT_STRING, false);
    }

    @Override
    public void setRelativeInitString(boolean b) {
        this.putProperty(RELATIVE_INIT_STRING, b);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.putProperty(ENABLED, enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.getBooleanProperty(ENABLED, true);
    }

    @Override
    public void setFlushPolicy(int i) {
        this.putProperty(FLUSH_POLICY, i);
    }

    @Override
    public int getFlushPolicy() {
        return this.getIntProperty(FLUSH_POLICY, 0);
    }

    @Override
    public void setFlushInterval(int interval) {
        this.putProperty(FLUSH_INTERVAL, interval);
    }

    @Override
    public int getFlushInterval() {
        return this.getIntProperty(FLUSH_INTERVAL, 5000);
    }

    @Override
    public void setIncludes(String includes) {
        this.putProperty(INCLUDES, includes);
    }

    @Override
    public String getIncludes() {
        return (String)this.getProperty(INCLUDES);
    }

    @Override
    public void setExcludes(String excludes) {
        this.putProperty(EXCLUDES, excludes);
    }

    @Override
    public String getExcludes() {
        return (String)this.getProperty(EXCLUDES);
    }

    @Override
    public void setContextFilterSpec(String ctx) {
        this.putProperty(CONTEXT, ctx);
    }

    @Override
    public String getContextFilterSpec() {
        return (String)this.getProperty(CONTEXT, DEFAULT_CONTEXT);
    }

    @Override
    public void setShowGutter(boolean b) {
        this.putProperty(SHOW_GUTTER, b);
    }

    @Override
    public boolean isShowGutter() {
        return this.getBooleanProperty(SHOW_GUTTER, true);
    }

    @Override
    public void setShowInline(boolean b) {
        this.putProperty(SHOW_INLINE, b);
    }

    @Override
    public boolean isShowInline() {
        return this.getBooleanProperty(SHOW_INLINE, true);
    }

    @Override
    public void setShowTooltips(boolean b) {
        this.putProperty(SHOW_TOOLTIPS, b);
    }

    @Override
    public boolean isShowTooltips() {
        return this.getBooleanProperty(SHOW_TOOLTIPS, true);
    }

    @Override
    public void setAutoRefresh(boolean b) {
        this.putProperty(AUTO_REFRESH, b);
    }

    @Override
    public boolean isAutoRefresh() {
        return this.getBooleanProperty(AUTO_REFRESH, true);
    }

    @Override
    public void setPeriodicRefresh(boolean b) {
        this.putProperty(PERIODIC_REFRESH, b);
    }

    @Override
    public boolean isPeriodicRefresh() {
        return this.getBooleanProperty(PERIODIC_REFRESH, false);
    }

    @Override
    public void setAutoRefreshInterval(int i) {
        this.putProperty(AUTO_REFRESH_INTERVAL, i);
    }

    @Override
    public int getAutoRefreshInterval() {
        return this.getIntProperty(AUTO_REFRESH_INTERVAL, 2000);
    }

    @Override
    public List<Regexp> getRegexpContexts() {
        return (List)this.getProperty(REGEXP_CONTEXTS, DEFAULT_REGEXP_CONTEXTS);
    }

    @Override
    public void setRegexpContexts(List<Regexp> l) {
        this.putProperty(REGEXP_CONTEXTS, l);
    }

    @Override
    public void setSpan(String interval) {
        this.putProperty(SPAN, interval);
    }

    @Override
    public String getSpan() {
        return (String)this.getProperty(SPAN, DEFAULT_SPAN);
    }

    @Override
    public Color getCoveredStripe() {
        return this.getColorProperty(COVERED_STRIPE);
    }

    @Override
    public void setCoveredStripe(Color c) {
        this.putColorProperty(COVERED_STRIPE, c);
    }

    @Override
    public Color getFailedCoveredStripe() {
        return this.getColorProperty(FAILED_COVERED_STRIPE);
    }

    @Override
    public void setFailedCoveredStripe(Color c) {
        this.putColorProperty(FAILED_COVERED_STRIPE, c);
    }

    @Override
    public Color getCoveredHighlight() {
        return this.getColorProperty(COVERED_HIGHLIGHT);
    }

    @Override
    public void setCoveredHighlight(Color c) {
        this.putColorProperty(COVERED_HIGHLIGHT, c);
    }

    @Override
    public Color getFailedCoveredHighlight() {
        return this.getColorProperty(FAILED_COVERED_HIGHLIGHT);
    }

    @Override
    public void setFailedCoveredHighlight(Color c) {
        this.putColorProperty(FAILED_COVERED_HIGHLIGHT, c);
    }

    @Override
    public Color getNotCoveredStripe() {
        return this.getColorProperty(NOT_COVERED_STRIPE);
    }

    @Override
    public void setNotCoveredStripe(Color c) {
        this.putColorProperty(NOT_COVERED_STRIPE, c);
    }

    @Override
    public Color getNotCoveredHighlight() {
        return this.getColorProperty(NOT_COVERED_HIGHLIGHT);
    }

    @Override
    public void setNotCoveredHighlight(Color c) {
        this.putColorProperty(NOT_COVERED_HIGHLIGHT, c);
    }

    @Override
    public Color getOutOfDateStripe() {
        return this.getColorProperty(OUTOFDATE_STRIPE);
    }

    @Override
    public void setOutOfDateStripe(Color c) {
        this.putColorProperty(OUTOFDATE_STRIPE, c);
    }

    @Override
    public Color getOutOfDateHighlight() {
        return this.getColorProperty(OUTOFDATE_HIGHLIGHT);
    }

    @Override
    public void setOutOfDateHighlight(Color c) {
        this.putColorProperty(OUTOFDATE_HIGHLIGHT, c);
    }

    @Override
    public Color getFilteredStripe() {
        return this.getColorProperty(FILTERED_STRIPE);
    }

    @Override
    public void setFilteredStripe(Color c) {
        this.putColorProperty(FILTERED_STRIPE, c);
    }

    @Override
    public Color getFilteredHighlight() {
        return this.getColorProperty(FILTERED_HIGHLIGHT);
    }

    @Override
    public void setFilteredHighlight(Color c) {
        this.putColorProperty(FILTERED_HIGHLIGHT, c);
    }

    @Override
    public String getLanguageLevel() {
        return (String)this.getProperty(LANGUAGE_LEVEL, "9");
    }

    @Override
    public void setLanguageLevel(String str) {
        this.putProperty(LANGUAGE_LEVEL, str);
    }

    @Override
    public boolean isLoadPerTestData() {
        return this.getBooleanProperty(LOAD_PER_TEST_DATA, true);
    }

    @Override
    public void setLoadPerTestData(boolean loadPerTestData) {
        this.putProperty(LOAD_PER_TEST_DATA, loadPerTestData);
    }

    @Override
    public ProjectRebuild getProjectRebuild() {
        return (ProjectRebuild)((Object)this.getProperty(PROJECT_REBUILD, (Object)DEFAULT_PROJECT_REBUILD));
    }

    @Override
    public void setProjectRebuild(ProjectRebuild projectRebuild) {
        this.putProperty(PROJECT_REBUILD, (Object)projectRebuild);
    }

    protected void setDefaults(Map<String, Object> propertyMap) {
        propertyMap.put(ENABLED, true);
        propertyMap.put(FLUSH_POLICY, 0);
        propertyMap.put(FLUSH_INTERVAL, 5000);
        propertyMap.put(AUTO_REFRESH, true);
        propertyMap.put(PERIODIC_REFRESH, false);
        propertyMap.put(AUTO_REFRESH_INTERVAL, 2000);
        propertyMap.put(SHOW_GUTTER, true);
        propertyMap.put(SHOW_INLINE, true);
        propertyMap.put(SHOW_TOOLTIPS, true);
        propertyMap.put(LANGUAGE_LEVEL, "9");
        propertyMap.put(AUTO_INIT_STRING, true);
        propertyMap.put(COVERED_HIGHLIGHT, Pair.of(DEFAULT_LIGHT_COVERED_HIGHLIGHT, DEFAULT_DARCULA_COVERED_HIGHLIGHT));
        propertyMap.put(COVERED_STRIPE, Pair.of(DEFAULT_LIGHT_COVERED_STRIPE, DEFAULT_DARCULA_COVERED_STRIPE));
        propertyMap.put(FAILED_COVERED_HIGHLIGHT, Pair.of(DEFAULT_LIGHT_FAILED_COVERED_HIGHLIGHT, DEFAULT_DARCULA_FAILED_COVERED_HIGHLIGHT));
        propertyMap.put(FAILED_COVERED_STRIPE, Pair.of(DEFAULT_LIGHT_FAILED_COVERED_STRIPE, DEFAULT_DARCULA_FAILED_COVERED_STRIPE));
        propertyMap.put(NOT_COVERED_HIGHLIGHT, Pair.of(DEFAULT_LIGHT_NOT_COVERED_HIGHLIGHT, DEFAULT_DARCULA_NOT_COVERED_HIGHLIGHT));
        propertyMap.put(NOT_COVERED_STRIPE, Pair.of(DEFAULT_LIGHT_NOT_COVERED_STRIPE, DEFAULT_DARCULA_NOT_COVERED_STRIPE));
        propertyMap.put(OUTOFDATE_HIGHLIGHT, Pair.of(DEFAULT_LIGHT_OUTOFDATE_HIGHLIGHT, DEFAULT_DARCULA_OUTOFDATE_HIGHLIGHT));
        propertyMap.put(OUTOFDATE_STRIPE, Pair.of(DEFAULT_LIGHT_OUTOFDATE_STRIPE, DEFAULT_DARCULA_OUTOFDATE_STRIPE));
        propertyMap.put(FILTERED_HIGHLIGHT, Pair.of(DEFAULT_LIGHT_FILTERED_HIGHLIGHT, DEFAULT_DARCULA_FILTERED_HIGHLIGHT));
        propertyMap.put(FILTERED_STRIPE, Pair.of(DEFAULT_LIGHT_FILTERED_STRIPE, DEFAULT_DARCULA_FILTERED_STRIPE));
        propertyMap.put(CONTEXT, DEFAULT_CONTEXT);
        propertyMap.put(REGEXP_CONTEXTS, DEFAULT_REGEXP_CONTEXTS);
        propertyMap.put(PROJECT_REBUILD, (Object)DEFAULT_PROJECT_REBUILD);
        propertyMap.put(BUILD_WITH_CLOVER, true);
    }

    @Override
    public boolean isBuildWithClover() {
        return this.getBooleanProperty(BUILD_WITH_CLOVER, true);
    }

    @Override
    public void setBuildWithClover(boolean buildWithClover) {
        this.putProperty(BUILD_WITH_CLOVER, buildWithClover);
    }

    @Override
    public void setInstrumentTests(boolean b) {
        this.putProperty(INSTRUMENT_TESTS, b);
    }

    @Override
    public boolean isInstrumentTests() {
        return this.getBooleanProperty(INSTRUMENT_TESTS, true);
    }

    @Override
    public void setDumpInstrumentedSources(boolean dump) {
        this.putProperty(DUMP_INSTRUMENTED_SOURCES, dump);
    }

    @Override
    public boolean isDumpInstrumentedSources() {
        return this.getBooleanProperty(DUMP_INSTRUMENTED_SOURCES, false);
    }

    @Override
    public void setInstrumentLambda(LambdaInstrumentation instrumentLambda) {
        this.putProperty(INSTRUMENT_LAMBDA, (Object)instrumentLambda);
    }

    @Override
    public LambdaInstrumentation getInstrumentLambda() {
        return (LambdaInstrumentation)((Object)this.getProperty(INSTRUMENT_LAMBDA, (Object)DEFAULT_INSTRUMENT_LAMBDA));
    }
}

