/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.MappedCloverPluginConfig;
import com.atlassian.clover.idea.config.TestCaseLayout;
import com.atlassian.clover.idea.config.TestViewScope;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.idea.util.ProjectUtil;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IdeaCloverConfig
extends MappedCloverPluginConfig {
    public static final String AUTO_SCROLL_TO_SOURCE = "autoScroll";
    public static final String AUTO_SCROLL_FROM_SOURCE = "autoScrollFromSource";
    public static final String FLATTEN_PACKAGES = "flattenPackages";
    public static final String SHOW_SUMMARY_IN_TOOLBAR = "showSummaryInToolbar";
    public static final String SHOW_SUMMARY_IN_TOOLWINDOW = "showSummaryInToolwindow";
    public static final String SHOW_ERROR_MARKS = "showErrorMarks";
    public static final String ALWAYS_EXPAND_TEST_CLASSES = "alwaysExpandTestClasses";
    public static final String ALWAYS_COLLAPSE_TEST_CLASSES = "alwaysCollapseTestClasses";
    public static final String HIGHLIGHT_COVERED = "highlightCovered";
    public static final String LAST_PROJECT_CONFIG_TAB_SELECTION = "lastProjectConfigTabSelection";
    public static final String MODEL_SCOPE = "modelScope";
    public static final String INCLUDE_PASSED_TEST_COVERAGE_ONLY = "includePassedTestCoverageOnly";
    public static final String TEST_VIEW_SCOPE = "testViewScope";
    public static final String TEST_CASE_LAYOUT = "testCaseLayout";
    public static final String CALCULATE_TEST_COVERAGE = "calculateTestCoverage";
    public static final String HIDE_FULLY_COVERED = "hideFullyCovered";
    public static final String VIEW_COVERAGE = "viewCoverage";
    public static final String VIEW_INCLUDE_ANNOTATION = "viewIncludeAnnotation";
    public static final String CLOUD_REPORT_INCLUDE_SUBPKGS = "cloudReportIncludeSubpkgs";
    public static final String CLOUD_AUTO_VIEW = "cloudAutoView";
    private static final boolean DEFAULT_SHOW_ERROR_MARKS = true;
    private static final boolean DEFAULT_SHOW_SUMMARY_IN_TOOLWINDOW = true;
    private static final boolean DEFAULT_SHOW_SUMMARY_IN_TOOLBAR = true;
    private static final boolean DEFAULT_FLATTEN_PACKAGES = false;
    private static final boolean DEFAULT_AUTO_SCROLL_TO_SOURCE = true;
    private static final boolean DEFAULT_AUTO_SCROLL_FROM_SOURCE = false;
    private static final boolean DEFAULT_ALWAYS_EXPAND_TEST_CLASSES = false;
    private static final boolean DEFAULT_ALWAYS_COLLAPSE_TEST_CLASSES = false;
    private static final boolean DEFAULT_HIGHLIGHT_COVERED = true;
    private static final int DEFAULT_LAST_PROJECT_CONFIG_TAB_SELECTION = 0;
    private static final ModelScope DEFAULT_MODEL_SCOPE = ModelScope.APP_CLASSES_ONLY;
    private static final boolean DEFAULT_INCLUDE_PASSED_TEST_COVERAGE_ONLY = true;
    private static final TestCaseLayout DEFAULT_TEST_CASE_LAYOUT = TestCaseLayout.TEST_CASES;
    private static final TestViewScope DEFAULT_TEST_VIEW_SCOPE = TestViewScope.GLOBAL;
    private static final boolean DEFAULT_CALCULATE_TEST_COVERAGE = true;
    private static final boolean DEFAULT_HIDE_FULLY_COVERED = false;
    private static final boolean DEFAULT_VIEW_COVERAGE = true;
    private static final boolean DEFAULT_VIEW_INCLUDE_ANNOTATION = true;
    private static final boolean DEFAULT_CLOUD_REPORT_INCLUDE_SUBPKGS = false;
    private static final boolean DEFAULT_CLOUD_AUTO_VIEW = true;
    private final Project project;

    public static IdeaCloverConfig fromProject(Project project) {
        return new IdeaCloverConfig(project);
    }

    private IdeaCloverConfig(Project project) {
        this.project = project;
        this.setDefaults(this.properties);
        this.calculateAndStoreGeneratedInitString(this.properties, project);
    }

    private void calculateAndStoreGeneratedInitString(Map<String, Object> properties, Project project) {
        if (project != null) {
            File projectWorkspace = ProjectUtil.getProjectWorkspace(project);
            File coverageDb = new File(projectWorkspace, "coverage.db");
            properties.put("generatedInitString", coverageDb.getAbsolutePath());
        } else {
            properties.put("generatedInitString", "coverage.db");
        }
    }

    public IdeaCloverConfig copyConfigTo(IdeaCloverConfig config) {
        IdeaCloverConfig theConfig = config != null ? config : new IdeaCloverConfig(this.project);
        theConfig.properties.clear();
        theConfig.properties.putAll(this.properties);
        return theConfig;
    }

    @Override
    protected void setDefaults(Map<String, Object> propertyMap) {
        super.setDefaults(propertyMap);
        propertyMap.put(SHOW_ERROR_MARKS, true);
        propertyMap.put(SHOW_SUMMARY_IN_TOOLBAR, true);
        propertyMap.put(SHOW_SUMMARY_IN_TOOLWINDOW, true);
        propertyMap.put(FLATTEN_PACKAGES, false);
        propertyMap.put(AUTO_SCROLL_TO_SOURCE, true);
        propertyMap.put(AUTO_SCROLL_FROM_SOURCE, false);
        propertyMap.put("instrumentTests", true);
        propertyMap.put(ALWAYS_COLLAPSE_TEST_CLASSES, false);
        propertyMap.put(ALWAYS_EXPAND_TEST_CLASSES, false);
        propertyMap.put(HIGHLIGHT_COVERED, true);
        propertyMap.put(LAST_PROJECT_CONFIG_TAB_SELECTION, 0);
        propertyMap.put(VIEW_COVERAGE, true);
        propertyMap.put(VIEW_INCLUDE_ANNOTATION, true);
        propertyMap.put(CALCULATE_TEST_COVERAGE, true);
        propertyMap.put(HIDE_FULLY_COVERED, false);
        propertyMap.put(MODEL_SCOPE, (Object)DEFAULT_MODEL_SCOPE);
        propertyMap.put(INCLUDE_PASSED_TEST_COVERAGE_ONLY, true);
        propertyMap.put(TEST_VIEW_SCOPE, (Object)DEFAULT_TEST_VIEW_SCOPE);
        propertyMap.put(TEST_CASE_LAYOUT, (Object)DEFAULT_TEST_CASE_LAYOUT);
        propertyMap.put(CLOUD_REPORT_INCLUDE_SUBPKGS, false);
    }

    public void setAutoScroll(boolean b) {
        this.putProperty(AUTO_SCROLL_TO_SOURCE, b);
    }

    public boolean isAutoScroll() {
        return this.getBooleanProperty(AUTO_SCROLL_TO_SOURCE, true);
    }

    public void setAutoScrollFromSource(boolean b) {
        this.putProperty(AUTO_SCROLL_FROM_SOURCE, b);
    }

    public boolean isAutoScrollFromSource() {
        return this.getBooleanProperty(AUTO_SCROLL_FROM_SOURCE, false);
    }

    public void setFlattenPackages(boolean b) {
        this.putProperty(FLATTEN_PACKAGES, b);
    }

    public boolean isFlattenPackages() {
        return this.getBooleanProperty(FLATTEN_PACKAGES, false);
    }

    public void setShowSummaryInToolbar(boolean b) {
        this.putProperty(SHOW_SUMMARY_IN_TOOLBAR, b);
    }

    public boolean isShowSummaryInToolbar() {
        return this.getBooleanProperty(SHOW_SUMMARY_IN_TOOLBAR, true);
    }

    public void setShowSummaryInToolwindow(boolean b) {
        this.putProperty(SHOW_SUMMARY_IN_TOOLWINDOW, b);
    }

    public boolean isShowSummaryInToolwindow() {
        return this.getBooleanProperty(SHOW_SUMMARY_IN_TOOLWINDOW, true);
    }

    public void setShowErrorMarks(boolean b) {
        this.putProperty(SHOW_ERROR_MARKS, b);
    }

    public boolean isShowErrorMarks() {
        return this.getBooleanProperty(SHOW_ERROR_MARKS, true);
    }

    public void setAlwaysExpandTestClasses(boolean b) {
        if (b) {
            this.setAlwaysCollapseTestClasses(false);
        }
        this.putProperty(ALWAYS_EXPAND_TEST_CLASSES, b);
    }

    public boolean isAlwaysExpandTestClasses() {
        return this.getBooleanProperty(ALWAYS_EXPAND_TEST_CLASSES, false);
    }

    public void setAlwaysCollapseTestClasses(boolean b) {
        if (b) {
            this.setAlwaysExpandTestClasses(false);
        }
        this.putProperty(ALWAYS_COLLAPSE_TEST_CLASSES, b);
    }

    public boolean isAlwaysCollapseTestClasses() {
        return this.getBooleanProperty(ALWAYS_COLLAPSE_TEST_CLASSES, false);
    }

    public void setHighlightCovered(boolean b) {
        this.putProperty(HIGHLIGHT_COVERED, b);
    }

    public boolean isHighlightCovered() {
        return this.getBooleanProperty(HIGHLIGHT_COVERED, true);
    }

    public void setLastProjectConfigTabSelected(int selection) {
        this.putProperty(LAST_PROJECT_CONFIG_TAB_SELECTION, selection);
    }

    public int getLastProjectConfigTabSelected() {
        return this.getIntProperty(LAST_PROJECT_CONFIG_TAB_SELECTION, 0);
    }

    @NotNull
    public ModelScope getModelScope() {
        return (ModelScope)((Object)this.getProperty(MODEL_SCOPE, (Object)DEFAULT_MODEL_SCOPE));
    }

    public void setModelScope(@NotNull ModelScope modelScope) {
        this.putProperty(MODEL_SCOPE, (Object)modelScope);
    }

    public boolean isIncludePassedTestCoverageOnly() {
        return this.getBooleanProperty(INCLUDE_PASSED_TEST_COVERAGE_ONLY, true);
    }

    public void setIncludePassedTestCoverageOnly(boolean includePassedTestCoverageOnly) {
        this.putProperty(INCLUDE_PASSED_TEST_COVERAGE_ONLY, includePassedTestCoverageOnly);
    }

    @NotNull
    public TestCaseLayout getTestCaseLayout() {
        return (TestCaseLayout)((Object)this.getProperty(TEST_CASE_LAYOUT, (Object)DEFAULT_TEST_CASE_LAYOUT));
    }

    public void setTestCaseLayout(TestCaseLayout testCaseLayout) {
        this.putProperty(TEST_CASE_LAYOUT, (Object)testCaseLayout);
    }

    public boolean isViewCoverage() {
        return this.getBooleanProperty(VIEW_COVERAGE, true);
    }

    public void setViewCoverage(boolean viewCoverage) {
        this.putProperty(VIEW_COVERAGE, viewCoverage);
    }

    public boolean isViewIncludeAnnotation() {
        return this.getBooleanProperty(VIEW_INCLUDE_ANNOTATION, true);
    }

    public void setViewIncludeAnnotation(boolean viewIncludeAnnotation) {
        this.putProperty(VIEW_INCLUDE_ANNOTATION, viewIncludeAnnotation);
    }

    @NotNull
    public TestViewScope getTestViewScope() {
        return (TestViewScope)((Object)this.getProperty(TEST_VIEW_SCOPE, (Object)DEFAULT_TEST_VIEW_SCOPE));
    }

    public void setTestViewScope(TestViewScope scope) {
        this.putProperty(TEST_VIEW_SCOPE, (Object)scope);
    }

    public boolean isCalculateTestCoverage() {
        return this.getBooleanProperty(CALCULATE_TEST_COVERAGE, true);
    }

    public void setCalculateTestCoverage(boolean state) {
        this.putProperty(CALCULATE_TEST_COVERAGE, state);
    }

    public boolean isHideFullyCovered() {
        return this.getBooleanProperty(HIDE_FULLY_COVERED, false);
    }

    public void setHideFullyCovered(boolean hideFullyCovered) {
        this.putProperty(HIDE_FULLY_COVERED, hideFullyCovered);
    }

    public boolean isCloudReportIncludeSubpkgs() {
        return this.getBooleanProperty(CLOUD_REPORT_INCLUDE_SUBPKGS, false);
    }

    public void setCloudReportIncludeSubpkgs(boolean include) {
        this.putProperty(CLOUD_REPORT_INCLUDE_SUBPKGS, include);
    }

    public boolean isAutoViewInCloudReport() {
        return this.getBooleanProperty(CLOUD_AUTO_VIEW, true);
    }

    public void setAutoViewInCloudReport(boolean auto) {
        this.putProperty(CLOUD_AUTO_VIEW, auto);
    }
}

