/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.openclover.util.Maps;

public class ConfigChangeEvent
extends EventObject {
    private final Map<String, PropertyChangeEvent> changedProperties = Maps.newHashMap();

    public ConfigChangeEvent(Object source) {
        this(source, Collections.emptyList());
    }

    public ConfigChangeEvent(Object source, List<PropertyChangeEvent> propertyChangeEvents) {
        super(source);
        for (PropertyChangeEvent evt : propertyChangeEvents) {
            this.changedProperties.put(evt.getPropertyName(), evt);
        }
    }

    public boolean hasPropertyChange(String propertyName) {
        return this.changedProperties.containsKey(propertyName);
    }

    public PropertyChangeEvent getPropertyChange(String propertyName) {
        return this.changedProperties.get(propertyName);
    }

    public PropertyChangeEvent[] getPropertyChanges() {
        Collection<PropertyChangeEvent> properties = this.changedProperties.values();
        return properties.toArray(new PropertyChangeEvent[properties.size()]);
    }
}

