/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openclover.util.Lists;

public abstract class AbstractInlineConfigPanel
extends ConfigPanel
implements ActionListener {
    private List<JCheckBox> checkboxes = null;

    public AbstractInlineConfigPanel() {
        this.initLayout();
        this.initListeners();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        List<JCheckBox> boxes = this.getCheckboxes();
        int[][] layout = this.getCheckboxLayout();
        int span = layout[0].length;
        if (this.getHelpText() != null) {
            this.add((Component)this.getHelpText(), new GBC(1, 1).setSpan(span, 1).setFill(2).setWeight(1.0, 0.0));
        }
        for (int i = 0; i < layout.length; ++i) {
            for (int j = 0; j < layout[i].length; ++j) {
                int index = layout[i][j];
                if (index == -1) continue;
                this.add((Component)boxes.get(index), new GBC(j + 1, i + 2).setAnchor(17));
            }
        }
        this.add((Component)new JPanel(), new GBC(1, layout.length + 2).setSpan(span, 1).setFill(1).setWeight(1.0, 1.0));
    }

    private void initListeners() {
    }

    public abstract JTextArea getHelpText();

    protected List<JCheckBox> getCheckboxes() {
        if (this.checkboxes == null) {
            this.checkboxes = Lists.newArrayList();
            for (String text : this.getDisplayNames()) {
                this.checkboxes.add(new JCheckBox(text));
            }
        }
        return this.checkboxes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public abstract List<String> getDisplayNames();

    public abstract int[][] getCheckboxLayout();

    @Override
    public void enableConfig(boolean b) {
        if (b) {
            this.setBorder(this.getEnabledBorder());
        } else {
            this.setBorder(this.getDisabledBorder());
        }
        if (this.getHelpText() != null) {
            this.getHelpText().setEnabled(b);
        }
        for (JCheckBox box : this.getCheckboxes()) {
            if (box == null) continue;
            box.setEnabled(b);
        }
    }
}

