/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.util.ComparatorUtil;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;

public abstract class AbstractCloverPluginConfig
implements CloverPluginConfig {
    private final Collection<ConfigChangeListener> listeners = Lists.newArrayList();
    private final PropertyChangeEventList propertyChangeEventList = new PropertyChangeEventList();
    private boolean dirty;

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty(boolean b) {
        this.dirty = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigChangeListener(ConfigChangeListener l) {
        Collection<ConfigChangeListener> collection = this.listeners;
        synchronized (collection) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigChangeListener(ConfigChangeListener l) {
        Collection<ConfigChangeListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void notifyListeners() {
        List<PropertyChangeEvent> copy = this.propertyChangeEventList.detachEvents();
        this.fireConfigChangeEvent(new ConfigChangeEvent(this, copy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireConfigChangeEvent(ConfigChangeEvent evt) {
        ArrayList<ConfigChangeListener> copy;
        Collection<ConfigChangeListener> collection = this.listeners;
        synchronized (collection) {
            copy = Lists.newArrayList(this.listeners);
        }
        for (ConfigChangeListener listener : copy) {
            listener.configChange(evt);
        }
    }

    @Override
    public void putProperty(String name, Object newValue) {
        Object oldValue = this.getProperty(name);
        if (ComparatorUtil.areEqual(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, name, oldValue, newValue);
        this.propertyChangeEventList.addEvent(evt);
        this.markDirty(true);
        this.writeProperty(evt.getPropertyName(), evt.getNewValue());
    }

    public void putProperty(String name, boolean b) {
        this.putProperty(name, (Object)b);
    }

    public void putProperty(String name, int i) {
        this.putProperty(name, new Integer(i));
    }

    public void putProperty(String name, long l) {
        this.putProperty(name, new Long(l));
    }

    public void putProperty(String name, float f) {
        this.putProperty(name, new Float(f));
    }

    public void putProperty(String name, double d) {
        this.putProperty(name, new Double(d));
    }

    public void putProperty(String name, byte b) {
        this.putProperty(name, new Byte(b));
    }

    public void putProperty(String name, short s) {
        this.putProperty(name, new Short(s));
    }

    public abstract void writeProperty(String var1, Object var2);

    @Nullable
    public abstract Object readProperty(String var1);

    @Override
    @Nullable
    public Object getProperty(String name) {
        return this.readProperty(name);
    }

    @NotNull
    public Object getProperty(String name, @NotNull Object defaultValue) {
        Object val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return (Boolean)val;
    }

    public int getIntProperty(String name, int defaultValue) {
        Object val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return (Integer)val;
    }

    public long getLongProperty(String name, long defaultValue) {
        Object val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return (Long)val;
    }

    private static class PropertyChangeEventList {
        private List<PropertyChangeEvent> propertyChanges = Lists.newArrayList();

        private PropertyChangeEventList() {
        }

        synchronized List<PropertyChangeEvent> detachEvents() {
            List<PropertyChangeEvent> copy = this.propertyChanges;
            this.propertyChanges = Lists.newArrayList();
            return copy;
        }

        synchronized void addEvent(PropertyChangeEvent event) {
            Iterator<PropertyChangeEvent> i = this.propertyChanges.iterator();
            while (i.hasNext()) {
                PropertyChangeEvent evt = i.next();
                if (!evt.getPropertyName().equals(event.getPropertyName())) continue;
                i.remove();
            }
            this.propertyChanges.add(event);
        }
    }
}

