/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.idea.build.InclusionDetector;
import com.atlassian.clover.idea.build.jps.CloverSerializerExtension;
import com.atlassian.clover.idea.build.jps.JpsModelUtil;
import com.atlassian.clover.idea.config.CloverModuleConfig;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.util.InclusionUtil;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class JpsProjectInclusionDetector
implements InclusionDetector {
    private boolean isIncluded = false;
    private boolean cloverDisabled = false;
    private boolean notJava = false;
    private boolean moduleNotFound = false;
    private boolean moduleExcluded = false;
    private boolean pathNotFound = false;
    private boolean patternExcluded = false;
    private boolean inTestSources = false;
    @Nullable
    private JpsModule enclosingModule;

    @NotNull
    public static InclusionDetector processFile(@NotNull JpsProject project, @NotNull File file) {
        CloverPluginConfig config = JpsModelUtil.getCloverPluginConfig(project);
        if (config != null) {
            return JpsProjectInclusionDetector.processFile(project, file, config);
        }
        JpsProjectInclusionDetector detector = new JpsProjectInclusionDetector();
        detector.cloverDisabled = false;
        return detector;
    }

    private JpsProjectInclusionDetector() {
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public boolean isModuleExcluded() {
        return this.moduleExcluded;
    }

    @Override
    public boolean isPathNotFound() {
        return this.pathNotFound;
    }

    @Override
    public boolean isPatternExcluded() {
        return this.patternExcluded;
    }

    @Override
    public boolean isInNoninstrumentedTestSources() {
        return this.inTestSources;
    }

    @Override
    public boolean isCloverDisabled() {
        return this.cloverDisabled;
    }

    @Override
    public boolean isNotJava() {
        return this.notJava;
    }

    @Override
    public boolean isModuleNotFound() {
        return this.moduleNotFound;
    }

    @Nullable
    protected JpsModule getEnclosingModule() {
        return this.enclosingModule;
    }

    @NotNull
    protected static InclusionDetector processFile(@NotNull JpsProject project, @NotNull File file, @NotNull CloverPluginConfig config) {
        JpsProjectInclusionDetector detector = new JpsProjectInclusionDetector();
        detector.cloverDisabled = !config.isEnabled() || !config.isBuildWithClover();
        detector.notJava = !JpsProjectInclusionDetector.hasJavaFileExtension(file);
        detector.enclosingModule = JpsModelUtil.findModuleForFile(project, file);
        if (detector.enclosingModule == null) {
            detector.moduleNotFound = true;
            return detector;
        }
        JpsSimpleElement element = (JpsSimpleElement)detector.enclosingModule.getContainer().getChild((JpsElementChildRole)CloverSerializerExtension.CloverModuleConfigurationRole.INSTANCE);
        if (element != null && ((CloverModuleConfig)element.getData()).isExcluded()) {
            detector.moduleExcluded = true;
            return detector;
        }
        String javaPath = JpsProjectInclusionDetector.getRootRelativeFileName(detector.enclosingModule, file);
        if (javaPath == null) {
            detector.pathNotFound = true;
            return detector;
        }
        if (!InclusionUtil.isIncluded(javaPath, InclusionUtil.toArray(config.getExcludes(), " ,"), InclusionUtil.toArray(config.getIncludes(), " ,"), true)) {
            detector.patternExcluded = true;
            return detector;
        }
        if (!config.isInstrumentTests() && JpsProjectInclusionDetector.isInTestSource(detector.enclosingModule, file)) {
            detector.inTestSources = true;
            return detector;
        }
        detector.isIncluded = true;
        return detector;
    }

    @Nullable
    protected static String getRootRelativeFileName(@NotNull JpsModule module, @NotNull File file) {
        JpsModuleSourceRoot sourceRoot = JpsModelUtil.findSourceRootForFile(module, file);
        return sourceRoot != null ? FileUtils.getRelativePath(sourceRoot.getFile(), file) : null;
    }

    protected static boolean isInTestSource(@NotNull JpsModule module, @NotNull File file) {
        JpsModuleSourceRoot sourceRoot = JpsModelUtil.findSourceRootForFile(module, file);
        return sourceRoot != null && sourceRoot.getRootType().equals(JavaSourceRootType.TEST_SOURCE);
    }

    private static boolean hasJavaFileExtension(@NotNull File file) {
        String fileNameLowerCase = file.getName().toLowerCase();
        for (String extension : Language.Builtin.JAVA.getFileExtensions()) {
            if (!fileNameLowerCase.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

