/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.build.jps.CloverJpsGlobalConfigurationSerializer;
import com.atlassian.clover.idea.build.jps.CloverJpsProjectConfigurationSerializer;
import com.atlassian.clover.idea.config.CloverModuleConfig;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.devkit.model.JpsPluginModuleType;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;
import org.openclover.util.Lists;

public class CloverSerializerExtension
extends JpsModelSerializerExtension {
    private static final Logger LOG = Logger.getInstance();

    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        return Lists.newArrayList(new CloverJpsGlobalConfigurationSerializer());
    }

    @NotNull
    public List<? extends JpsModulePropertiesSerializer<?>> getModulePropertiesSerializers() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        return Lists.newArrayList(new CloverJpsProjectConfigurationSerializer());
    }

    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module.getModuleType() instanceof JpsJavaModuleType || module.getModuleType() instanceof JpsPluginModuleType) {
            Element componentElement = JDomSerializationUtil.findComponent((Element)rootElement, (String)"Clover");
            boolean isExcluded = Boolean.parseBoolean(componentElement != null ? JDOMExternalizerUtil.readField((Element)componentElement, (String)"excluded", (String)"false") : "false");
            JpsSimpleElement simpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new CloverModuleConfig(isExcluded));
            module.getContainer().setChild((JpsElementChildRole)CloverModuleConfigurationRole.INSTANCE, (JpsElement)simpleElement);
            LOG.debug("Clover: attaching module settings (isExcluded=" + isExcluded + ") to module " + module.getName());
        } else {
            LOG.debug("Clover: unsupported module type: " + module.getModuleType() + ", skipping.");
        }
    }

    public static class CloverModuleConfigurationRole
    extends JpsElementChildRole<JpsSimpleElement<CloverModuleConfig>> {
        public static final CloverModuleConfigurationRole INSTANCE = new CloverModuleConfigurationRole();

        private CloverModuleConfigurationRole() {
        }
    }
}

