/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.idea.util.CharsetUtil;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.instr.java.InstrumentationSource;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class VirtualFileInstrumentationSource
implements InstrumentationSource {
    private final VirtualFile virtualFile;

    public VirtualFileInstrumentationSource(VirtualFile virtualFile) {
        this.virtualFile = virtualFile;
    }

    @Override
    public File getSourceFileLocation() {
        return VfsUtil.convertToFile(this.virtualFile);
    }

    @Override
    public Reader createReader() throws IOException {
        String fileEncoding = CharsetUtil.getFileEncoding(this.virtualFile);
        if (fileEncoding == null) {
            return new InputStreamReader(this.virtualFile.getInputStream());
        }
        return new InputStreamReader(this.virtualFile.getInputStream(), fileEncoding);
    }
}

