/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.idea.LibrarySupport;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.util.MiscUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;

public class CloverLibraryInjector
implements ConfigChangeListener {
    private final Project project;

    public CloverLibraryInjector(Project project) {
        this.project = project;
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("buildWithClover") || evt.hasPropertyChange("enabled")) {
            this.updateModulesDependencies();
        }
    }

    public void updateModulesDependencies() {
        if (this.isCloverInstrumentationEnabled()) {
            this.addCloverLibrary(ModuleManager.getInstance((Project)this.project).getModules());
        } else {
            this.removeCloverLibrary(ModuleManager.getInstance((Project)this.project).getModules());
        }
    }

    private void addCloverLibrary(final Module[] modules) {
        Runnable addLibrary = new Runnable(){

            @Override
            public void run() {
                Library cloverLibrary = LibrarySupport.getValidatedCloverLibrary();
                boolean isModified = false;
                for (Module module : modules) {
                    isModified |= LibrarySupport.addLibraryTo(cloverLibrary, module);
                }
                if (isModified) {
                    CloverLibraryInjector.this.project.save();
                }
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            MiscUtils.invokeWriteActionAndWait(addLibrary);
        } else {
            ApplicationManager.getApplication().runWriteAction(addLibrary);
        }
    }

    private void removeCloverLibrary(final Module[] modules) {
        Runnable removeLibrary = new Runnable(){

            @Override
            public void run() {
                boolean isModified = false;
                for (Module module : modules) {
                    isModified |= LibrarySupport.removeCloverLibraryFrom(module);
                }
                if (isModified) {
                    CloverLibraryInjector.this.project.save();
                }
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            MiscUtils.invokeWriteActionAndWait(removeLibrary);
        } else {
            ApplicationManager.getApplication().runWriteAction(removeLibrary);
        }
    }

    private boolean isCloverInstrumentationEnabled() {
        return ProjectPlugin.getPlugin(this.project).getConfig().isEnabled() && ProjectPlugin.getPlugin(this.project).getConfig().isBuildWithClover();
    }
}

