/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.autoupdater;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.autoupdater.AutoUpdateConfiguration;
import com.atlassian.clover.idea.autoupdater.CloverPluginDownloader;
import com.atlassian.clover.idea.autoupdater.LatestVersionInfo;
import com.atlassian.clover.idea.autoupdater.NewVersionNotifier;
import com.atlassian.clover.idea.config.AutoUpdateConfigPanel;
import com.atlassian.clover.idea.util.NetUtil;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.ExceptionDialog;
import com.atlassian.clover.versions.LibraryVersion;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CloverAutoUpdate", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class AutoUpdateComponent
implements ApplicationComponent,
Runnable,
PersistentStateComponent<AutoUpdateConfiguration> {
    private static final long INIT_DELAY = 60L;
    private static final long INTERVAL = 86400L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    public static final String STABLE_URL = "https://openclover.org/update/latestStableVersion.xml";
    private final Logger LOG = Logger.getInstance("autoupdate");
    private ScheduledFuture<?> scheduledFuture;
    private LatestVersionInfo lastVersion;
    private boolean newVersionAvailable;
    private AutoUpdateConfiguration config = new AutoUpdateConfiguration();
    private final SearchableConfigurable configurable = new SearchableConfigurable(){
        private AutoUpdateConfigPanel configPanel;

        public String getId() {
            return "Clover Auto Update";
        }

        public Runnable enableSearch(String s) {
            return null;
        }

        public String getDisplayName() {
            return "Auto Update";
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            if (this.configPanel == null) {
                this.configPanel = new AutoUpdateConfigPanel();
                this.configPanel.setAutoUpdateConfig(AutoUpdateComponent.this.config);
            }
            return this.configPanel;
        }

        public void disposeUIResources() {
            this.configPanel = null;
        }

        public boolean isModified() {
            return !AutoUpdateComponent.this.config.equals(this.configPanel.getAutoUpdateConfig());
        }

        public void apply() throws ConfigurationException {
            AutoUpdateComponent.this.loadState(this.configPanel.getAutoUpdateConfig());
        }

        public void reset() {
            this.configPanel.setAutoUpdateConfig(AutoUpdateComponent.this.config);
        }
    };
    private boolean downloadInProgressOrDone;

    @NotNull
    public String getComponentName() {
        return "Clover Autoupdater";
    }

    public void initComponent() {
        if (this.config.isAutoUpdate()) {
            this.startScheduler();
        }
    }

    public void disposeComponent() {
        this.stopScheduler();
    }

    private void startScheduler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.scheduledFuture == null) {
            this.scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(this, 60L, 86400L, TIME_UNIT);
        }
    }

    private void stopScheduler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public synchronized AutoUpdateConfiguration getState() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(AutoUpdateConfiguration state) {
        AutoUpdateComponent autoUpdateComponent = this;
        synchronized (autoUpdateComponent) {
            this.config = new AutoUpdateConfiguration(state);
        }
        if (this.config.isAutoUpdate()) {
            this.startScheduler();
        } else {
            this.stopScheduler();
        }
    }

    public SearchableConfigurable getConfigurable() {
        return this.configurable;
    }

    private static String getValue(Document document, String path) {
        try {
            Element element = (Element)XPath.selectSingleNode((Object)document, (String)path);
            if (element == null || element.getValue() == null) {
                Logger.getInstance("autoupdate").info("Version info descriptor does not contain " + path);
                return null;
            }
            return element.getValue().trim();
        }
        catch (JDOMException e) {
            Logger.getInstance("autoupdate").info("Error parsing version info descriptor");
            return null;
        }
    }

    static LatestVersionInfo parse(Document document) {
        return new LatestVersionInfo(AutoUpdateComponent.getValue(document, "/response/version/number"), AutoUpdateComponent.getValue(document, "/response/version/downloadUrl"), AutoUpdateComponent.getValue(document, "/response/version/releaseNotes"), AutoUpdateComponent.getValue(document, "/response/version/releaseNotesUrl"));
    }

    private void handleVersion(@NotNull LatestVersionInfo versionInfo) {
        this.setNewVersion(versionInfo);
        AutoUpdateComponent.updateNotifiers();
    }

    private static void updateNotifiers() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            NewVersionNotifier notifier = (NewVersionNotifier)project.getComponent(NewVersionNotifier.class);
            if (notifier == null) continue;
            notifier.update();
        }
    }

    public boolean showNewVersionAvailable() {
        return this.newVersionAvailable && !this.downloadInProgressOrDone;
    }

    public LatestVersionInfo getLastVersion() {
        return this.lastVersion;
    }

    private void setNewVersion(@NotNull LatestVersionInfo versionInfo) {
        this.lastVersion = versionInfo;
        this.newVersionAvailable = new LibraryVersion("4.5.0").compareTo(new LibraryVersion(versionInfo.getNumber())) < 0 && !this.getState().getIgnoredVersions().contains(versionInfo.getNumber());
    }

    public void resetLastVersion() {
        this.newVersionAvailable = false;
        AutoUpdateComponent.updateNotifiers();
    }

    @Override
    public void run() {
        try {
            final LatestVersionInfo latestVersion = AutoUpdateComponent.checkLatestVersion();
            if (latestVersion != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoUpdateComponent.this.handleVersion(latestVersion);
                    }
                });
            } else {
                this.LOG.info("Cannot retrieve latest version info (null)");
            }
        }
        catch (Exception e) {
            this.LOG.info("Cannot retrieve latest version info", e);
        }
    }

    @Nullable
    public static LatestVersionInfo checkLatestVersion() throws JDOMException, IOException {
        InputStream stream = NetUtil.openUrlStream(STABLE_URL);
        if (stream != null) {
            try {
                Document document = new SAXBuilder().build(stream);
                LatestVersionInfo latestVersionInfo = AutoUpdateComponent.parse(document);
                return latestVersionInfo;
            }
            finally {
                stream.close();
            }
        }
        return null;
    }

    public void performUpdate(@NotNull String downloadUrl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.downloadInProgressOrDone) {
            return;
        }
        this.downloadInProgressOrDone = true;
        AutoUpdateComponent.updateNotifiers();
        CloverPluginDownloader downloadTask = new CloverPluginDownloader(downloadUrl){

            @Override
            public void onFailure(Exception ex) {
                AutoUpdateComponent.this.downloadInProgressOrDone = false;
                AutoUpdateComponent.updateNotifiers();
                ExceptionDialog.showOKDialog(null, CloverIdeaPluginMessages.getString("autoupdate.errordownloading"), "", ex, CloverIdeaPluginMessages.getString("autoupdate.errordownloading"));
            }

            @Override
            public void onTrueSuccess() {
                int resp = Messages.showYesNoDialog((String)CloverIdeaPluginMessages.getString("autoupdate.restart"), (String)CloverIdeaPluginMessages.getString("autoupdate.updatingplugin"), (Icon)Messages.getQuestionIcon());
                if (resp == 0) {
                    ApplicationManager.getApplication().restart();
                }
            }

            public void onCancel() {
                AutoUpdateComponent.this.downloadInProgressOrDone = false;
                AutoUpdateComponent.updateNotifiers();
            }
        };
        downloadTask.queue();
    }

    public static AutoUpdateComponent getInstance() {
        return (AutoUpdateComponent)ApplicationManager.getApplication().getComponent(AutoUpdateComponent.class);
    }

    public void addIgnoredVersion(String number) {
        this.getState().addIgnoredVersion(number);
    }
}

