/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.actions;

import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;

public class ViewUncoveredCoverageAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent event) {
        Project project = (Project)DataKeys.PROJECT.getData(event.getDataContext());
        if (project == null) {
            return false;
        }
        IdeaCloverConfig cloverConfig = ProjectPlugin.getPlugin(project).getConfig();
        return cloverConfig.isShowInline() && !cloverConfig.isHighlightCovered();
    }

    public void setSelected(AnActionEvent event, boolean b) {
        Project project;
        if (b && (project = (Project)DataKeys.PROJECT.getData(event.getDataContext())) != null) {
            IdeaCloverConfig cloverConfig = ProjectPlugin.getPlugin(project).getConfig();
            cloverConfig.setHighlightCovered(false);
            cloverConfig.setShowInline(true);
            cloverConfig.notifyListeners();
        }
    }

    public void update(AnActionEvent event) {
        super.update(event);
        boolean enabled = false;
        Project project = (Project)DataKeys.PROJECT.getData(event.getDataContext());
        if (project != null) {
            enabled = ProjectPlugin.getPlugin(project).getFeatureManager().isFeatureEnabled("clover-reporting");
        }
        event.getPresentation().setVisible(enabled);
    }
}

