/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.Logger;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.idea.CloverToolWindow;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectEnabledListener;
import com.atlassian.clover.idea.build.CloverCompiler;
import com.atlassian.clover.idea.build.CloverLibraryInjector;
import com.atlassian.clover.idea.build.ProjectRebuilder;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.content.ContentManager;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.coverage.DefaultCoverageManager;
import com.atlassian.clover.idea.coverage.EventListenerInstallator;
import com.atlassian.clover.idea.coverage.monitor.ProcessExitDatabaseMonitor;
import com.atlassian.clover.idea.coverage.monitor.PropertyCoverageMonitor;
import com.atlassian.clover.idea.coverage.monitor.ThreadedDatabaseMonitor;
import com.atlassian.clover.idea.feature.ConfigPropertyCategory;
import com.atlassian.clover.idea.feature.FeatureManager;
import com.atlassian.clover.idea.feature.FeatureTreeNode;
import com.atlassian.clover.idea.testexplorer.TestRunExplorerToolWindow;
import com.atlassian.clover.idea.util.ProjectUtil;
import com.atlassian.clover.idea.util.jdom.JDOMExternUtil;
import com.atlassian.clover.util.Path;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CloverPlugin", storages={@Storage(id="workspace", file="$WORKSPACE_FILE$")})
public class ProjectPlugin
implements IProjectPlugin,
ProjectComponent,
ModuleRootListener,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance("CLOVER:ProjectPlugin");
    private final Project project;
    private IdeaCloverConfig config;
    private ContentManager nManager;
    private CoverageManager cManager;
    private FeatureManager fManager;
    private ThreadedDatabaseMonitor dbMonitor;
    private CloverCompiler compiler;
    private boolean initialized;

    public ProjectPlugin(Project project) {
        this.project = project;
        this.config = IdeaCloverConfig.fromProject(this.project);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                ProjectPlugin.this.projectPostStartup();
            }
        });
    }

    public static IProjectPlugin getPlugin(@NotNull Project proj) {
        return (IProjectPlugin)proj.getComponent(IProjectPlugin.class);
    }

    @Nullable
    public static IProjectPlugin getPlugin(AnActionEvent event) {
        Project project = (Project)DataKeys.PROJECT.getData(event.getDataContext());
        return project == null ? null : ProjectPlugin.getPlugin(project);
    }

    void projectPostStartup() {
        CloverLibraryInjector cloverLibraryInjector = new CloverLibraryInjector(this.project);
        cloverLibraryInjector.updateModulesDependencies();
        this.config.addConfigChangeListener(cloverLibraryInjector);
        ProjectRebuilder projectRebuilder = ProjectRebuilder.getInstance(this.project);
        this.config.addConfigChangeListener(projectRebuilder);
        CloverToolWindow.getInstance(this.project).register();
        TestRunExplorerToolWindow.getInstance(this.project).register();
        EventListenerInstallator.install(this.project, FileEditorManagerListener.FILE_EDITOR_MANAGER, this.getContentManager());
        this.dbMonitor = new ThreadedDatabaseMonitor();
        this.dbMonitor.setCoverageManager(this.getCoverageManager());
        this.dbMonitor.setMonitorInterval(this.config.getAutoRefreshInterval());
        FeatureManager featureManager = this.getFeatureManager();
        featureManager.addFeatureListener("clover-refresh", this.dbMonitor);
        featureManager.addFeatureListener("clover-building", projectRebuilder);
        this.config.addConfigChangeListener(this.dbMonitor);
        if (featureManager.isFeatureEnabled("clover-refresh")) {
            this.dbMonitor.start();
        }
        new ProjectEnabledListener().register(featureManager);
        this.compiler = new CloverCompiler(this.project);
        CompilerManager.getInstance((Project)this.project).addCompiler((Compiler)this.compiler);
        EventListenerInstallator.install(this.project, ProjectTopics.PROJECT_ROOTS, this);
        this.initialized = true;
        ProcessExitDatabaseMonitor executionListener = new ProcessExitDatabaseMonitor(ProjectPlugin.getPlugin(this.project).getCoverageManager(), ProjectPlugin.getPlugin(this.project).getConfig());
        EventListenerInstallator.install(this.project, ExecutionManager.EXECUTION_TOPIC, executionListener);
        if (this.config.isAutoRefresh()) {
            this.getCoverageManager().reload();
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        if (!this.initialized) {
            return;
        }
        CompilerManager.getInstance((Project)this.project).removeCompiler((Compiler)this.compiler);
        CloverToolWindow.getInstance(this.project).cleanup();
        TestRunExplorerToolWindow.getInstance(this.project).unregister();
        this.compiler.cleanup();
        this.dbMonitor.cleanup();
        this.nManager.cleanup();
        this.cManager.cleanup();
    }

    public ContentManager getContentManager() {
        if (this.nManager == null) {
            this.nManager = new ContentManager(this.project);
            this.nManager.init();
        }
        return this.nManager;
    }

    @Override
    public IdeaCloverConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.getFeatureManager().isFeatureEnabled("clover");
    }

    private static Path getProjectSourcePath(Project project) {
        VirtualFile[] roots;
        Path path = new Path();
        for (VirtualFile root : roots = ProjectRootManager.getInstance((Project)project).getContentSourceRoots()) {
            path.append(root.getPath());
        }
        return path;
    }

    @Override
    public CoverageManager getCoverageManager() {
        if (this.cManager == null) {
            String initString = this.config.getInitString();
            this.cManager = new DefaultCoverageManager(this.project, initString);
            this.cManager.setSpan(new Interval(this.config.getSpan()).getValueInMillis());
            this.cManager.setContextFilter(this.config.getContextFilterSpec());
            this.cManager.setSourcePath(ProjectPlugin.getProjectSourcePath(this.project));
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.cManager.reload();
            } else {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectPlugin.this.cManager.reload();
                    }
                });
            }
            PropertyCoverageMonitor monitor = new PropertyCoverageMonitor(this.config);
            monitor.setCoverageManager(this.cManager);
            monitor.start();
        }
        return this.cManager;
    }

    @Override
    public FeatureManager getFeatureManager() {
        if (this.fManager == null) {
            this.fManager = new FeatureManager();
            FeatureTreeNode root = new FeatureTreeNode(new ConfigPropertyCategory("clover", "enabled", this.config));
            FeatureTreeNode reporting = new FeatureTreeNode(new ConfigPropertyCategory("reporting", "viewCoverage", this.config));
            FeatureTreeNode building = new FeatureTreeNode(new ConfigPropertyCategory("building", "buildWithClover", this.config));
            FeatureTreeNode tooltip = new FeatureTreeNode(new ConfigPropertyCategory("tooltips", "showTooltips", this.config));
            FeatureTreeNode inline = new FeatureTreeNode(new ConfigPropertyCategory("inline", "showInline", this.config));
            FeatureTreeNode gutter = new FeatureTreeNode(new ConfigPropertyCategory("gutter", "showGutter", this.config));
            FeatureTreeNode errorMarks = new FeatureTreeNode(new ConfigPropertyCategory("errormarks", "showErrorMarks", this.config));
            FeatureTreeNode refresh = new FeatureTreeNode(new ConfigPropertyCategory("refresh", "periodicRefresh", this.config));
            FeatureTreeNode iconDecoration = new FeatureTreeNode(new ConfigPropertyCategory("icondecoration", "viewIncludeAnnotation", this.config));
            root.addChild(reporting);
            root.addChild(building);
            root.addChild(refresh);
            root.addChild(iconDecoration);
            reporting.addChild(tooltip);
            reporting.addChild(inline);
            reporting.addChild(gutter);
            reporting.addChild(errorMarks);
            this.fManager.registerFeatureTree(root);
        }
        return this.fManager;
    }

    public File getProjectWorkspace() {
        return ProjectUtil.getProjectWorkspace(this.project);
    }

    @NotNull
    public String getComponentName() {
        return "CloverPlugin";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void beforeRootsChange(ModuleRootEvent moduleRootEvent) {
    }

    public void rootsChanged(ModuleRootEvent moduleRootEvent) {
        if (this.cManager != null) {
            LOG.info("rootsChanged - refreshing coverage manager");
            this.cManager.setSourcePath(ProjectPlugin.getProjectSourcePath(this.project));
        }
    }

    public Element getState() {
        Element element = new Element("element");
        try {
            JDOMExternUtil.writeTo(element, this.config);
            this.config.markDirty(false);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return element;
    }

    public void loadState(Element element) {
        try {
            JDOMExternUtil.readTo(element, this.config);
        }
        catch (Exception e) {
            LOG.warn("problem reading config", e);
        }
        this.config.notifyListeners();
        this.config.markDirty(false);
    }
}

